<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\AdminText;

class AdminTextController extends Controller
{
    public function edit()
    {
        $text = AdminText::first();
        if(!$text){
            $text = AdminText::create([
                'popular_category_title' => 'জনপ্রিয় ক্যাটাগরি',
                'view_all_text' => 'View All',
                'add_to_cart_text' => 'কার্টে যোগ করুন',
                'order_now_text' => 'অর্ডার করুন',
                'product_code_label' => 'প্রোডাক্ট কোড',
                'courier_delivery_title' => 'কুরিয়ার ডেলিভারি খরচ',
                'short_description_title' => 'Short Description',
            ]);
        }
        return view('backend.admin_texts.edit', compact('text'));
    }

    public function update(Request $request)
    {
        $text = AdminText::first() ?? new AdminText();

        $text->popular_category_title  = $request->popular_category_title;
        $text->view_all_text           = $request->view_all_text;
        $text->add_to_cart_text        = $request->add_to_cart_text;
        $text->order_now_text          = $request->order_now_text;
        $text->product_code_label      = $request->product_code_label;
        $text->courier_delivery_title  = $request->courier_delivery_title;
        $text->short_description_title = $request->short_description_title;

        $text->save();

        return back()->with('success','Admin Text Updated Successfully!');
    }
}
