@extends('backend.app')
@push('css')
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.css" />
@endpush

@section('content')
<div class="row">
    <div class="col-12">
        <div class="page-title-box">
            <div class="page-title-right">
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item"><a href="javascript: void(0);">SIS</a></li>
                    <li class="breadcrumb-item"><a href="javascript: void(0);">CRM</a></li>
                    <li class="breadcrumb-item active">Page Create</li>
                </ol>
            </div>
            <h4 class="page-title">Page Create</h4>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">

                <form method="POST" enctype="multipart/form-data" action="{{ route('admin.landing_pages.store') }}" id="ajax_form">
                    @csrf
                    <div class="row">

                        <div class="col-lg-12">
                            <div class="mb-3">
                                <label class="form-label">Page Title</label>
                                <input type="text" name="title1" class="form-control" placeholder="Title" required>
                            </div>
                        </div>

                        <div class="col-lg-12">
                            <div class="mb-3">
                                <label class="form-label">Background Image</label>
                                <input type="file" name="landing_bg" class="form-control">
                            </div>
                        </div>

                        <div class="col-lg-12">
                            <div class="mb-3">
                                <label class="form-label">Video Url (Embedded Code)</label>
                                <input type="text" name="video_url" class="form-control" placeholder="Video embed code">
                            </div>
                        </div>

                        <div class="col-lg-12">
                            <div class="mb-3">
                                <label class="form-label">Call Text</label>
                                <input type="text" name="call_text" class="form-control" placeholder="Call text">
                            </div>
                        </div>

                        <div class="col-lg-12"><div class="mb-3">
                            <label class="form-label">Regular Price Text</label>
                            <input type="text" name="regular_price_text" class="form-control">
                        </div></div>

                        <div class="col-lg-12"><div class="mb-3">
                            <label class="form-label">Offer Price Text</label>
                            <input type="text" name="offer_price_text" class="form-control">
                        </div></div>

                        <div class="col-lg-12"><div class="mb-3">
                            <label class="form-label">Left Side Text</label>
                            <input type="text" name="left_side_title" class="form-control">
                        </div></div>

                        <div class="col-lg-12"><div class="mb-3">
                            <label class="form-label">Left Side Details</label>
                            <textarea class="form-control summernote" name="left_side_desc" rows="6"></textarea>
                        </div></div>

                        <div class="col-lg-12"><div class="mb-3">
                            <label class="form-label">Right Side Text</label>
                            <input type="text" name="right_side_title" class="form-control">
                        </div></div>

                        <div class="col-lg-12"><div class="mb-3">
                            <label class="form-label">Right Side Details</label>
                            <textarea class="form-control summernote" name="right_side_desc" rows="6"></textarea>
                        </div></div>

                        <div class="col-lg-12"><div class="mb-3">
                            <label class="form-label">Top Heading Text</label>
                            <input type="text" name="top_heading_text" class="form-control">
                        </div></div>

                        <div class="col-lg-12"><div class="mb-3">
                            <label class="form-label">Left Product Details</label>
                            <textarea class="form-control summernote" name="left_product_details" rows="6"></textarea>
                        </div></div>

                        <div class="col-lg-12"><div class="mb-3">
                            <label class="form-label">Right Product Image</label>
                            <input type="file" name="right_product_image" class="form-control">
                        </div></div>

                        <div class="col-lg-12"><div class="mb-3">
                            <label class="form-label">Slider Top Text</label>
                            <input type="text" name="feature" class="form-control">
                        </div></div>

                        <div class="col-lg-12"><div class="mb-3">
                            <label class="form-label">Slider Image</label>
                            <input type="file" name="sliderimage[]" class="form-control" multiple>
                        </div></div>

                        <div class="col-lg-12"><div class="mb-3">
                            <label class="form-label">Review Top Text</label>
                            <input type="text" name="review_top_text" class="form-control">
                        </div></div>

                        <div class="col-lg-12"><div class="mb-3">
                            <label class="form-label">Review Image</label>
                            <input type="file" name="review_product_image[]" class="form-control" multiple>
                        </div></div>

                        <div class="col-lg-12"><div class="mb-3">
                            <label class="form-label">Old Price</label>
                            <input type="text" name="old_price" class="form-control">
                        </div></div>

                        <div class="col-lg-12"><div class="mb-3">
                            <label class="form-label">New Price</label>
                            <input type="text" name="new_price" class="form-control">
                        </div></div>

                        <div class="col-lg-12"><div class="mb-3">
                            <label class="form-label">Phone Number</label>
                            <input type="text" name="phone" class="form-control">
                        </div></div>

                        <div class="col-lg-12">
                            <div class="mb-3">
                                <label class="form-label">Add Product</label>
                                <input type="text" id="search2" class="form-control" placeholder="product search here">
                            </div>
                        </div>

                        <input type="hidden" id="product_id" name="product_id" value="">
                        <div id="data"></div>

                        <div class="col-lg-12">
                            <div class="mb-3">
                                {{-- ✅ FIX: submit না, button করে দিলাম যাতে browser default submit + ajax submit একসাথে না হয় --}}
                                <button type="button" id="save_btn" class="btn btn-primary">Save</button>
                            </div>
                        </div>

                    </div>
                </form>

            </div>
        </div>
    </div>
</div>
@endsection

@push('js')
<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.20/dist/summernote-lite.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.20/dist/summernote-lite.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js"></script>

<script>
$(document).ready(function() {
    $('.summernote').summernote({ height: 200 });
});
</script>

<script>
var path2 = "{{ route('admin.getOrderProduct2') }}";
const products = [];

$("#search2").autocomplete({
    selectFirst: true,
    minLength: 2,
    source: function(request, response) {
        $.ajax({
            url: path2,
            type: 'GET',
            dataType: "json",
            data: { search: request.term },
            success: function(data) {
                if (data.length == 0) {
                    toastr.error('Product Or Stock Not Found');
                } else if (data.length == 1) {
                    if (products.indexOf(data[0].id) == -1) {
                        landingProductEntry(data[0]);
                        products.push(data[0].id);
                    }
                    $('#search2').val('');
                } else {
                    response(data);
                }
            }
        });
    },
    select: function(event, ui) {
        if (products.indexOf(ui.item.id) == -1) {
            landingProductEntry(ui.item);
            products.push(ui.item.id);
        }
        $('#search2').val('');
        return false;
    }
});

function landingProductEntry(item)
{
    $.ajax({
        url: '{{ route("admin.landingProductEntry")}}',
        type: 'GET',
        dataType: "json",
        data: { id: item.id },
        success: function(res) {
            if (res.html) {
                $('div#data').html(res.html);
            }
            if (res.pr_id) {
                $('#product_id').val(parseInt(res.pr_id, 10));
            }
        }
    });
}

/**
 * ✅ FIX:
 * - submit handler বাদ (global handler থাকলে/enter press এ double request যেতে পারে)
 * - শুধু save_btn click এ ajax যাবে
 * - lock => একাধিক click এ ২টা create হবে না
 * - success => controller থেকে url এলে সেটায় যাবে, না হলে index route
 */
$(document).off('click.lp_create', '#save_btn').on('click.lp_create', '#save_btn', function(e){
    e.preventDefault();
    e.stopImmediatePropagation();

    const form = document.getElementById('ajax_form');
    const btn  = $('#save_btn');

    if (btn.data('submitting') === 1) return false;
    btn.data('submitting', 1);

    btn.prop('disabled', true).text('Saving...');

    let formData = new FormData(form);

    $.ajax({
        url: $(form).attr('action'),
        type: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        cache: false,
        headers: { 'X-Requested-With': 'XMLHttpRequest' },
        success: function(res){
            const redirectUrl = (res && res.url) ? res.url : "{{ route('admin.landing_pages.index') }}";
            window.location.href = redirectUrl;
        },
        error: function(xhr){
            if (xhr.status === 422 && xhr.responseJSON && xhr.responseJSON.errors) {
                let firstKey = Object.keys(xhr.responseJSON.errors)[0];
                let msg = xhr.responseJSON.errors[firstKey][0] || 'Validation error';
                toastr.error(msg);
            } else {
                toastr.error('Something went wrong!');
                console.log(xhr.responseText);
            }

            btn.data('submitting', 0);
            btn.prop('disabled', false).text('Save');
        }
    });

    return false;
});
</script>
@endpush
