@extends('backend.app')
@push('css')
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.css" />
@endpush

@section('content')
<div class="row">
    <div class="col-12">
        <div class="page-title-box">
            <div class="page-title-right">
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item"><a href="javascript: void(0);">SIS</a></li>
                    <li class="breadcrumb-item"><a href="javascript: void(0);">CRM</a></li>
                    <li class="breadcrumb-item active">Page update</li>
                </ol>
            </div>
            <h4 class="page-title">Landing Page update</h4>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">

                <form method="POST" enctype="multipart/form-data" action="{{ route('admin.landing_pages.update',[$item->id])}}" id="ajax_form">
                    @csrf
                    @method('PATCH')
                    <div class="row">

                        <div class="col-lg-12">
                            <div class="mb-3">
                                <label class="form-label">Page Title</label>
                                <input type="text" value="{{ $item->title1 }}" name="title1" class="form-control" required>
                                <input type="hidden" name="product_id" value="{{ $item->product_id }}">
                                <input type="hidden" id="new_product_id" name="new_product_id">
                            </div>
                        </div>

                        <div class="col-lg-12">
                            <div class="img-box mb-2">
                                @if($item->landing_bg)
                                    <img src="{{ asset('landing_pages/'.$item->landing_bg)}}" width="60">
                                @endif
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Background Image</label>
                                <input type="file" name="landing_bg" class="form-control">
                            </div>
                        </div>

                        <div class="col-lg-12"><div class="mb-3">
                            <label class="form-label">Video Url (Embedded Code)</label>
                            <input type="text" value="{{ $item->video_url }}" name="video_url" class="form-control">
                        </div></div>

                        <div class="col-lg-12"><div class="mb-3">
                            <label class="form-label">Call Text</label>
                            <input type="text" name="call_text" value="{{ $item->call_text }}" class="form-control">
                        </div></div>

                        <div class="col-lg-12"><div class="mb-3">
                            <label class="form-label">Regular Price Text</label>
                            <input type="text" name="regular_price_text" value="{{ $item->regular_price_text }}" class="form-control">
                        </div></div>

                        <div class="col-lg-12"><div class="mb-3">
                            <label class="form-label">Offer Price Text</label>
                            <input type="text" name="offer_price_text" value="{{ $item->offer_price_text }}" class="form-control">
                        </div></div>

                        <div class="col-lg-12"><div class="mb-3">
                            <label class="form-label">Left Side Text</label>
                            <input type="text" name="left_side_title" value="{{ $item->left_side_title }}" class="form-control">
                        </div></div>

                        <div class="col-lg-12"><div class="mb-3">
                            <label class="form-label">Left Side Details</label>
                            <textarea class="form-control summernote" name="left_side_desc">{!! $item->left_side_desc !!}</textarea>
                        </div></div>

                        <div class="col-lg-12"><div class="mb-3">
                            <label class="form-label">Right Side Text</label>
                            <input type="text" name="right_side_title" value="{{ $item->right_side_title }}" class="form-control">
                        </div></div>

                        <div class="col-lg-12"><div class="mb-3">
                            <label class="form-label">Right Side Details</label>
                            <textarea class="form-control summernote" name="right_side_desc">{!! $item->right_side_desc !!}</textarea>
                        </div></div>

                        <div class="col-lg-12"><div class="mb-3">
                            <label class="form-label">Top Heading Text</label>
                            <input type="text" name="top_heading_text" value="{{ $item->top_heading_text }}" class="form-control">
                        </div></div>

                        <div class="col-lg-12"><div class="mb-3">
                            <label class="form-label">Left Product Details</label>
                            <textarea class="form-control summernote" name="left_product_details">{!! $item->left_product_details !!}</textarea>
                        </div></div>

                        <div class="col-lg-12">
                            <div class="img-box mb-2">
                                @if($item->right_product_image)
                                    <img src="{{ asset('landing_pages/'.$item->right_product_image)}}" width="60">
                                @endif
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Right Product Image</label>
                                <input type="file" name="right_product_image" class="form-control">
                            </div>
                        </div>

                        <div class="col-lg-12 mb-3">
                            <label class="form-label">Slider Top Text</label>
                            <input type="text" name="feature" value="{{ $item->feature }}" class="form-control">
                        </div>

                        <div class="col-lg-12 mb-3">
                            <div class="d-flex flex-wrap">
                                @foreach ($item->images as $image)
                                    <div class="img-box me-2 mb-2">
                                        <a href="{{ route('admin.delete_slider',[$image->id])}}" onclick="return confirm(' you want to delete?');">&times;</a>
                                        <img src="{{ getImage('landing_sliders',$image->image)}}" width="60">
                                    </div>
                                @endforeach
                            </div>
                            <label class="form-label">Slider Image</label>
                            <input type="file" name="sliderimage[]" class="form-control" multiple>
                        </div>

                        <div class="col-lg-12 mb-3">
                            <label class="form-label">Review Top Text</label>
                            <input type="text" name="review_top_text" value="{{ $item->review_top_text }}" class="form-control">
                        </div>

                        <div class="col-lg-12 mb-3">
                            <div class="d-flex flex-wrap">
                                @foreach ($review_images as $review_image)
                                    <div class="img-box me-2 mb-2">
                                        <a href="{{ route('admin.delete_review',[$review_image->id])}}" onclick="return confirm(' you want to delete?');">&times;</a>
                                        <img src="{{ asset('review_landing_sliders/'.$review_image->review_image) }}" width="60">
                                    </div>
                                @endforeach
                            </div>
                            <label class="form-label">Review Image</label>
                            <input type="file" name="review_product_image[]" class="form-control" multiple>
                        </div>

                        <div class="col-lg-12"><div class="mb-3">
                            <label class="form-label">Old Price</label>
                            <input type="text" name="old_price" value="{{ $item->old_price }}" class="form-control">
                        </div></div>

                        <div class="col-lg-12"><div class="mb-3">
                            <label class="form-label">New Price</label>
                            <input type="text" name="new_price" value="{{ $item->new_price }}" class="form-control">
                        </div></div>

                        <div class="col-lg-12"><div class="mb-3">
                            <label class="form-label">Phone Number</label>
                            <input type="text" name="phone" value="{{ $item->phone }}" class="form-control">
                        </div></div>

                        <div class="col-lg-12" id="product_search" style="display: {{ $single_product ? 'none' : 'block' }};">
                            <div class="mb-3">
                                <label class="form-label">Add Product</label>
                                <input type="text" id="search2" class="form-control" placeholder="product search here">
                            </div>
                        </div>

                        {{-- ✅ FIX: duplicate id="data" remove করে unique container --}}
                        <div class="product_table" id="product_container">
                            <table class="table table-centered table-nowrap mb-0" id="product_table">
                                <thead class="table-light">
                                    <tr>
                                        <th>Image</th>
                                        <th>Product</th>
                                        <th>Size</th>
                                        <th>Color</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody id="data">
                                    @if($single_product)
                                    <tr>
                                        <td><img src="{{ getImage('products', $single_product->image) }}" height="50" width="50"/></td>
                                        <td>{{ $single_product->name }}</td>
                                        <td>{{ optional($single_product->variation->size)->title }}</td>
                                        <td>{{ optional($single_product->variation->color)->name }}</td>
                                        <td><a class="remove btn btn-sm btn-danger"><i class="mdi mdi-delete"></i></a></td>
                                    </tr>
                                    @endif
                                </tbody>
                            </table>
                        </div>

                        <div class="col-lg-12">
                            <div class="mb-3">
                                {{-- ✅ FIX: submit না, button করে দিলাম যাতে browser default submit + ajax submit একসাথে না হয় --}}
                                <button type="button" id="save_btn" class="btn btn-primary">Save</button>
                            </div>
                        </div>

                    </div>
                </form>

            </div>
        </div>
    </div>
</div>
@endsection

@push('js')
<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.20/dist/summernote-lite.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.20/dist/summernote-lite.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js"></script>

<script>
$(document).ready(function() {
    $('.summernote').summernote({ height: 200 });
});
</script>

<script>
var path2 = "{{ route('admin.getOrderProduct2') }}";
const products = [];

$("#search2").autocomplete({
    selectFirst: true,
    minLength: 2,
    source: function(request, response) {
        $.ajax({
            url: path2,
            type: 'GET',
            dataType: "json",
            data: { search: request.term },
            success: function(data) {
                if (data.length == 0) {
                    toastr.error('Product Or Stock Not Found');
                } else if (data.length == 1) {
                    if (products.indexOf(data[0].id) == -1) {
                        landingProductEntry(data[0]);
                        products.push(data[0].id);
                    }
                    $('#search2').val('');
                } else {
                    response(data);
                }
            }
        });
    },
    select: function(event, ui) {
        if (products.indexOf(ui.item.id) == -1) {
            landingProductEntry(ui.item);
            products.push(ui.item.id);
        }
        $('#search2').val('');
        return false;
    }
});

function landingProductEntry(item)
{
    $.ajax({
        url: '{{ route("admin.landingProductEntry")}}',
        type: 'GET',
        dataType: "json",
        data: { id: item.id },
        success: function(res) {
            if (res.html) {
                // ✅ FIX: tbody#data তে বসবে
                $('tbody#data').html(res.html);
            }
            if (res.pr_id) {
                $('#new_product_id').val(res.pr_id);
            }
        }
    });
}

$(document).off('click.lp_remove', '.remove').on('click.lp_remove', ".remove", function(e){
    e.preventDefault();
    e.stopImmediatePropagation();
    $(this).closest("tr").remove();
    document.getElementById('product_search').style.display = 'block';
});

/**
 * ✅ FIX:
 * - submit handler বাদ (global handler থাকলে double call হয়)
 * - save_btn click only one
 * - lock => double click/enter press এ ২টা request যাবে না
 * - success => always redirect
 */
$(document).off('click.lp_update', '#save_btn').on('click.lp_update', '#save_btn', function(e){
    e.preventDefault();
    e.stopImmediatePropagation();

    const form = document.getElementById('ajax_form');
    const btn  = $('#save_btn');

    if (btn.data('submitting') === 1) return false;
    btn.data('submitting', 1);

    btn.prop('disabled', true).text('Saving...');

    let formData = new FormData(form);

    $.ajax({
        url: $(form).attr('action'),
        type: 'POST', // PATCH will be handled by _method in formData
        data: formData,
        processData: false,
        contentType: false,
        cache: false,
        headers: { 'X-Requested-With': 'XMLHttpRequest' },
        success: function(res){
            const redirectUrl = (res && res.url) ? res.url : "{{ route('admin.landing_pages.index') }}";
            window.location.href = redirectUrl;
        },
        error: function(xhr){
            if (xhr.status === 422 && xhr.responseJSON && xhr.responseJSON.errors) {
                let firstKey = Object.keys(xhr.responseJSON.errors)[0];
                let msg = xhr.responseJSON.errors[firstKey][0] || 'Validation error';
                toastr.error(msg);
            } else {
                toastr.error('Something went wrong');
                console.log(xhr.responseText);
            }

            btn.data('submitting', 0);
            btn.prop('disabled', false).text('Save');
        }
    });

    return false;
});
</script>
@endpush
