@extends('frontend.app')

@section('content')

@php
    use App\Models\AdminText;

    // ✅ DB থেকে টেক্সট লোড
    $adminText = AdminText::first();

    // ✅ ডিফল্ট ভ্যালু সেট করা
    $popularTitle = $adminText->popular_category_title ?? 'জনপ্রিয় ক্যাটাগরি';
    $viewAllText  = $adminText->view_all_text ?? 'View All';
@endphp

<style>
    /* ------- GLOBAL & UTILS ------- */
    .row>[class*=col] { padding-left: 5px !important; padding-right: 5px !important; }
     
    /* ------- HERO SLIDER LAYOUT ------- */
    .desktop-slide { display: block; }
    .mobile-slide { display: none; }

    @media (max-width: 991px){
        .desktop-slide { display: none !important; }
        .mobile-slide { display: block !important; }
    }

    /* Slider Container */
    .hero-slider-wrap {
        margin-top: 20px;
        margin-bottom: 25px;
        border-radius: 16px; /* More rounded */
        overflow: hidden;
        box-shadow: 0 15px 40px rgba(0,0,0,0.1); /* Deeper shadow */
        background: #000; /* Black bg prevents white flash during fade */
        position: relative;
        z-index: 1;
    }

    /* ✅ PREMIUM SLIDER ANIMATION (Ken Burns Effect) */
    .swiper-slide {
        overflow: hidden;
        width: 100%;
        height: auto;
    }

    /* Image Initial State */
    .swiper-slide img {
        width: 100%;
        height: auto;
        display: block;
        object-fit: cover;
        transform: scale(1);
        transition: transform 6s cubic-bezier(0.25, 0.46, 0.45, 0.94); /* Smooth long zoom */
        will-change: transform;
    }

    /* Active State - Slow Zoom In */
    .swiper-slide-active img {
        transform: scale(1.12); /* Zoom effect */
    }

    /* ✅ GLASSMORPHISM NAVIGATION ARROWS */
    .swiper-button-next, .swiper-button-prev {
        color: #fff !important;
        background: rgba(255, 255, 255, 0.1);
        width: 45px;
        height: 45px;
        border-radius: 50%;
        backdrop-filter: blur(10px);
        -webkit-backdrop-filter: blur(10px);
        border: 1px solid rgba(255, 255, 255, 0.2);
        transition: all 0.3s ease;
        opacity: 0; /* Initially hidden */
    }
    .hero-slider-wrap:hover .swiper-button-next,
    .hero-slider-wrap:hover .swiper-button-prev {
        opacity: 1; /* Show on hover */
    }
    
    .swiper-button-next:after, .swiper-button-prev:after { font-size: 16px; font-weight: 700; }
    .swiper-button-next:hover, .swiper-button-prev:hover { 
        background: rgba(255, 255, 255, 0.9); 
        color: #000 !important;
        transform: scale(1.1);
    }
     
    /* ✅ STYLISH PAGINATION DOTS */
    .swiper-pagination-bullet { 
        background: rgba(255,255,255,0.5) !important; 
        opacity: 1; 
        width: 8px; 
        height: 8px; 
        transition: all 0.3s ease;
        margin: 0 6px !important;
    }
    .swiper-pagination-bullet-active { 
        background: #fff !important; 
        width: 30px; 
        border-radius: 4px; 
        box-shadow: 0 0 10px rgba(255,255,255,0.6);
    }

    /* =========================================
        ------- POPULAR CATEGORY STYLES ------- 
       ========================================= */
    .popular_product {
        align-items: center; display: flex; flex-flow: row wrap;
        justify-content: center; position: relative; width: 100%;
        margin-top: 40px; margin-bottom: 25px; padding: 0 15px;
    }
    .popular_product span {
        font-size: 26px; font-family: 'Hind Siliguri', sans-serif;
        color: #0f172a; font-weight: 800; padding: 0 25px;
        text-transform: uppercase; letter-spacing: 0.5px;
    }
    .popular_product b {
        display: block; flex: 1; height: 1px;
        background: linear-gradient(90deg, transparent, rgba(0,0,0,0.1), transparent);
    }
    .popular_swiper_wrap {
        position: relative; width: 100%; max-width: 100%; margin: 0 !important;
        padding: 10px 0 30px 0 !important; background: transparent; overflow: hidden !important; 
    }
    .popular-swiper { width: 100%; overflow: visible !important; padding: 5px 0 !important; }
    .popular-swiper .swiper-wrapper { transition-timing-function: linear !important; }
    .popular-swiper .swiper-slide { padding: 15px 12px !important; height: auto; }

    /* Pop Card */
    .pop-card {
        display: flex; flex-direction: column; align-items: center;
        text-decoration: none !important; background: #ffffff; 
        border-radius: 20px; position: relative;
        transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        padding: 15px; height: 100%; border: 1px solid rgba(0,0,0,0.04);
        box-shadow: 0 10px 20px -5px rgba(0,0,0,0.03);
    }
    .pop-card:hover { 
        transform: translateY(-8px); 
        box-shadow: 0 20px 30px -10px rgba(0, 39, 108, 0.15); 
        border-color: rgba(0, 39, 108, 0.1);
    }
    .pop-img { 
        width: 100%; display: flex; align-items: center; justify-content: center; 
        min-height: 130px; background: #f8f9fc; border-radius: 16px;
        margin-bottom: 12px; padding: 15px; transition: background 0.3s ease;
    }
    .pop-card:hover .pop-img { background: #f0f4ff; }
    .pop-card img { 
        width: 100%; max-height: 100px; object-fit: contain; 
        transition: transform 0.4s ease; filter: drop-shadow(0 5px 10px rgba(0,0,0,0.05));
    }
    .pop-card:hover img { transform: scale(1.12); }
    .pop-title {
        font-family: 'Hind Siliguri', sans-serif; font-weight: 700; color: #334155;
        font-size: 16px; margin: 5px 0 0; text-align: center; width: 100%;
        white-space: nowrap; overflow: hidden; text-overflow: ellipsis; transition: color 0.3s ease;
    }
    .pop-card:hover .pop-title { color: #00276C; }

    @media (max-width: 767px){
        .popular_product { margin-top: 25px; margin-bottom: 15px; }
        .popular_product span { font-size: 20px; padding: 0 15px; }
        .pop-card { border-radius: 16px; padding: 10px; }
        .pop-img { min-height: 90px; padding: 10px; border-radius: 12px; margin-bottom: 8px; }
        .pop-card img { max-height: 70px; }
        .pop-title { font-size: 13px; font-weight: 600; }
        .pop-card { box-shadow: 0 4px 15px -3px rgba(0,0,0,0.05); }
    }

    /* ------- BUTTONS ------- */
    
    /* ✅ 5px GAP FIX HERE */
    .view_all { 
        margin-bottom: 5px !important; 
    }

    .view_all .viewall-btn{
        display:inline-flex !important; align-items:center !important; justify-content:center !important;
        gap:8px !important; padding: 8px 16px !important; border-radius: 999px !important;
        font-weight: 700 !important; font-size: 13px !important; line-height: 1 !important;
        text-decoration: none !important; color:#fff !important;
        border: 1px solid rgba(255,255,255,.18) !important;
        box-shadow: 0 8px 20px rgba(0,39,108,.25) !important;
        transition: all .22s ease !important;
    }
    .view_all .viewall-btn:hover{ transform: translateY(-2px) !important; filter: brightness(1.05) !important; }
    .view_all .viewall-btn .ic{
        width: 24px; height: 24px; border-radius: 999px; display:inline-flex;
        align-items:center; justify-content:center; background: rgba(255,255,255,.18); margin-right: 6px;
    }
    
    .bottom-cta-container { text-align: center; margin-top: 40px; margin-bottom: 60px; }
    .bottom-view-btn {
        display: inline-flex; align-items: center; justify-content: center; gap: 10px;
        padding: 14px 40px; font-size: 16px; font-weight: 700; text-transform: uppercase;
        letter-spacing: 0.5px; color: #fff !important; border-radius: 50px; text-decoration: none;
        box-shadow: 0 10px 30px rgba(0,39,108,0.3); transition: all 0.3s ease; border: 2px solid transparent;
    }
    .bottom-view-btn:hover {
        transform: translateY(-5px); box-shadow: 0 15px 40px rgba(0,39,108,0.45);
        filter: brightness(1.1); border-color: rgba(255,255,255,0.2);
    }
</style>

<main class="main-wrapper">

    {{-- ✅ DESKTOP SLIDER --}}
    <div class="desktop-slide container-fluid">
        <div class="hero-slider-wrap">
            <div class="swiper main-swiper desktop-swiper">
                <div class="swiper-wrapper">
                    @foreach($sliders as $s)
                        <div class="swiper-slide">
                            <a href="{{$s->link}}">
                                <img src="{{ getImage('sliders', $s->image) }}" alt="Slider Image">
                            </a>
                        </div>
                    @endforeach
                </div>
                <div class="swiper-button-next"></div>
                <div class="swiper-button-prev"></div>
                <div class="swiper-pagination"></div>
            </div>
        </div>
    </div>

    {{-- ✅ MOBILE SLIDER --}}
    <div class="mobile-slide container-fluid px-2">
        <div class="hero-slider-wrap" style="margin-top: 10px;">
            <div class="swiper main-swiper mobile-swiper">
                <div class="swiper-wrapper">
                    @foreach($sliders as $s)
                        <div class="swiper-slide">
                            <a href="{{$s->link}}">
                                <img src="{{ getImage('mobile_sliders', $s->mobile_image) }}" alt="Mobile Slider">
                            </a>
                        </div>
                    @endforeach
                </div>
                <div class="swiper-pagination"></div>
            </div>
        </div>
    </div>

    {{-- ✅ POPULAR CATEGORY SECTION --}}
    <div class="desktop home-menu mt-0">
        <div class="container-fluid mb-4 my-lg-5 slider_cat px-0">
            <div class="header-navbar header_navbar">
                <div class="header-main-nav">

                    <div class="popular_product">
                        <b></b><span>{{ $popularTitle }}</span><b></b>
                    </div>

                    <div class="popular_swiper_wrap">
                        <div class="swiper popular-swiper">
                            <div class="swiper-wrapper">
                                @foreach($cats as $cat)
                                    <div class="swiper-slide">
                                        <a href="{{ route('front.subCategories1', [$cat->url]) }}" class="pop-card">
                                            <div class="pop-img">
                                                <img src="{{ getImage('categories', $cat->image) }}" alt="{{ $cat->name }}">
                                            </div>
                                            <p class="pop-title">{{ $cat->name }}</p>
                                        </a>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <div style="width: 100%; height: 10px;"></div>

    {{-- ✅ PRODUCTS LOOP --}}
    @foreach ($homeProducts as $categoryId => $products)
        <div class="container-fluid px-0">
            <div class="card border-0">
                <div class="card-body p-1">
                    <div class="container-fluid" style="margin-bottom: 20px;padding-left: 5px;padding-right: 5px;">
                        <div class="bg-gradient container-fluid" style="padding: 10px 1px;">
                            <div class="col-12 product-header">
                                <div class="section_title text-light">
                                    @if(!empty($products->first()->category->id))
                                        <div class="d-flex border-bottom border-2 border-dark align-items-center">
                                            <div class="flex-fill view_left">
                                                <a href="{{ route('front.subCategories1',[$products->first()->category->url])}}" style="color: #218A41;">
                                                    <h4 class="p-2 pe-3 m-0 prodCatcus " style="text-align:left;font-family: 'Hind Siliguri', sans-serif">
                                                        <span style="width: 100%;" class=" d-block">{{ $products->first()->category->name }}</span>
                                                    </h4>
                                                </a>
                                            </div>
                                            <div class="view_all">
                                                <a href="{{ route('front.subCategories1',[$products->first()->category->url])}}" class="viewall-btn main-bg">
                                                    <span class="ic"><i class="fas fa-arrow-right"></i></span>
                                                    {{ $viewAllText }}
                                                </a>
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="container-fluid" style="margin-bottom: 20px;">
                        <div class="slick-single-layout">
                            <div class="row row--15">
                                @foreach($products as $product)
                                    <div class="col-lg-2 col-md-3 col-6 mb--30">
                                        @include('frontend.products.partials.product_section', ['adminText' => $adminText])
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endforeach

    <div class="bottom-cta-container desktop-slide">
        <a href="{{ route('front.products.index') }}" class="bottom-view-btn main-bg">
            View All Products <i class="fas fa-arrow-right"></i>
        </a>
    </div>

</main>

@endsection

@push('js')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css">
<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function () {

    // ✅ PREMIUM DESKTOP SLIDER CONFIG
    const desktopSwiper = new Swiper('.desktop-swiper', {
        loop: true,
        effect: 'fade', // 🔥 Fade Effect
        fadeEffect: { crossFade: true },
        speed: 1200, 
        autoplay: {
            delay: 4500,
            disableOnInteraction: false,
        },
        observer: true, 
        observeParents: true,
        pagination: {
            el: '.swiper-pagination',
            clickable: true,
        },
        navigation: {
            nextEl: '.swiper-button-next',
            prevEl: '.swiper-button-prev',
        },
    });

    // ✅ PREMIUM MOBILE SLIDER CONFIG
    const mobileSwiper = new Swiper('.mobile-swiper', {
        loop: true,
        effect: 'fade', 
        fadeEffect: { crossFade: true },
        speed: 1000,
        autoplay: {
            delay: 4000,
            disableOnInteraction: false,
        },
        observer: true,
        observeParents: true,
        pagination: {
            el: '.swiper-pagination',
            clickable: true,
        },
    });

    // 3. POPULAR CATEGORY (Ticker Mode)
    const wrap = document.querySelector('.popular-swiper .swiper-wrapper');
    if (wrap) {
        const originalSlides = Array.from(wrap.children);
        const needMin = 20; 
        if (originalSlides.length > 0 && originalSlides.length < needMin) {
            let guard = 0;
            while (wrap.children.length < needMin && guard < 50) {
                originalSlides.forEach(sl => {
                    wrap.appendChild(sl.cloneNode(true));
                });
                guard++;
            }
        }
    }
    
    const popularSwiper = new Swiper('.popular-swiper', {
        loop: true,
        observer: true,
        observeParents: true,
        autoplay: { delay: 0, disableOnInteraction: false, pauseOnMouseEnter: true },
        speed: 4000, 
        freeMode: true,
        slidesPerView: 2.6,
        spaceBetween: 0,
        breakpoints: {
            576:  { slidesPerView: 3.6 },
            768:  { slidesPerView: 4.6 },
            992:  { slidesPerView: 6 },
            1200: { slidesPerView: 6 }
        }
    });
});
</script>

<script>
(function(){
    function getCsrf(){
        const meta = document.querySelector('meta[name="csrf-token"]');
        return meta ? meta.getAttribute('content') : '';
    }

    document.addEventListener('click', function(e){
        const btn = e.target.closest('button[type="submit"]');
        if(!btn) return;
        const form = btn.closest('form');
        if(!form) return;

        if(form.getAttribute('action') && form.getAttribute('action').includes('carts')){
            form.classList.add('cart_form');
            let at = form.querySelector('input[name="action_type"]');
            if(!at){
                at = document.createElement('input');
                at.type = 'hidden';
                at.name = 'action_type';
                form.appendChild(at);
            }
            at.value = btn.getAttribute('data-action') || 'order';
        }
    });

    document.addEventListener('submit', function(e){
        const form = e.target;
        if(!form || !form.classList.contains('cart_form')) return;
        e.preventDefault();

        const actionUrl = form.getAttribute('action');
        const fd = new FormData(form);

        fetch(actionUrl, {
            method: 'POST',
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'X-CSRF-TOKEN': getCsrf()
            },
            body: fd
        })
        .then(r => r.json())
        .then(res => {
            if(res && res.url){
                window.location.href = res.url;
                return;
            }
            window.location.reload();
        })
        .catch(() => window.location.reload());
    }, true);
})();
</script>
@endpush