<head>
    @php
        use App\Models\Information;
        $information = Information::first();
    @endphp

    <!-- Basic Meta -->
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>@yield('title', $information->site_name)</title>
    <meta name="robots" content="index, follow">

    <!-- SEO Meta -->
    <meta name="description"
          content="@yield(
              'meta_description',
              $information->site_name . ' is an online marketplace in Bangladesh offering quality products, fair prices, and reliable service.'
          )">

    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Favicon -->
    <link rel="shortcut icon" type="image/x-icon"
          href="{{ asset('uploads/img/'.$information->fav_icon) }}">

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Oswald:wght@100;200;300;400;500&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@100;300;400;500;700;900&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;700&display=swap" rel="stylesheet">

    <!-- Font Awesome (Single Source – FIXED) -->
    <link rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/v4-shims.min.css">

    <!-- ✅ FINAL FIX: fal fa-arrow-up (WHITE, SOLID, VISIBLE) -->
    <style>
        i.fal.fa-arrow-up,
        i.fas.fa-arrow-up,
        .fal.fa-arrow-up,
        .fas.fa-arrow-up,
        i.fa-arrow-up,
        .fa-arrow-up{
            font-family: "Font Awesome 5 Free" !important;
            font-weight: 900 !important;
            font-style: normal !important;
            color: #ffffff !important;
            display: inline-block !important;
            visibility: visible !important;
            opacity: 1 !important;
        }
    </style>

    <!-- Vendor CSS -->
    <link rel="stylesheet" href="{{ asset('frontend/css/vendor/bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ asset('frontend/css/vendor/flaticon/flaticon.css') }}">
    <link rel="stylesheet" href="{{ asset('frontend/css/vendor/slick.css') }}">
    <link rel="stylesheet" href="{{ asset('frontend/css/vendor/slick-theme.css') }}">
    <link rel="stylesheet" href="{{ asset('frontend/css/vendor/jquery-ui.min.css') }}">
    <link rel="stylesheet" href="{{ asset('frontend/css/vendor/sal.css') }}">
    <link rel="stylesheet" href="{{ asset('frontend/css/vendor/magnific-popup.css') }}">
    <link rel="stylesheet" href="{{ asset('frontend/css/vendor/base.css') }}">

    <!-- Theme CSS -->
    <link rel="stylesheet" href="{{ asset('frontend/css/style.min.css') }}">
    <link rel="stylesheet" href="{{ asset('frontend/css/header.css') }}">
    <link rel="stylesheet" href="{{ asset('frontend/css/update.css') }}">

    <!-- Toastr CSS -->
    <link rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">

    <!-- SweetAlert -->
    <link rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.min.css">

    @stack('css')

    <!-- Tracking / Analytics -->
    {!! $information->tracking_code !!}

    <!-- Facebook Pixel -->
    @if($information->fb_pixel_id)
        <script>
            !function(f,b,e,v,n,t,s){
                if(f.fbq)return;
                n=f.fbq=function(){n.callMethod?
                n.callMethod.apply(n,arguments):n.queue.push(arguments)};
                if(!f._fbq)f._fbq=n;
                n.push=n;
                n.loaded=!0;
                n.version='2.0';
                n.queue=[];
                t=b.createElement(e);t.async=!0;
                t.src=v;
                s=b.getElementsByTagName(e)[0];
                s.parentNode.insertBefore(t,s)
            }(window, document,'script','https://connect.facebook.net/en_US/fbevents.js');

            fbq('init', '{{ $information->fb_pixel_id }}');
            fbq('track', 'PageView');
        </script>

        <noscript>
            <img height="1" width="1" style="display:none"
                 src="https://www.facebook.com/tr?id={{ $information->fb_pixel_id }}&ev=PageView&noscript=1">
        </noscript>
    @endif

    <!-- ✅ JS fallback: fal → fas (auto) -->
    <script>
        document.addEventListener("DOMContentLoaded", function () {
            document.querySelectorAll("i.fal.fa-arrow-up").forEach(function (el) {
                el.classList.remove("fal");
                el.classList.add("fas");
            });
        });
    </script>
</head>
