@php
use App\Models\Information;
use App\Models\Category;

$information = Information::first();
$categories  = Category::whereNull('parent_id')->where('is_menu', 1)->with('subcats')->get();

/**
 * ✅ brand colors
 * - Dropdown background = gradient_code
 * - Dropdown text = primary_color
 */
$brandGradient = $information->gradient_code ?? 'linear-gradient(90deg,#0d6efd,#00276C)';
$brandText     = $information->primary_color ?? '#ffffff';
@endphp

<style>
    :root{
        --brand-gradient: {!! $brandGradient !!};
        --brand-text: {{ $brandText }};
    }

    .main-bg {
        background: var(--brand-gradient) !important;
        border-color: rgba(32, 124, 202, 1);
        color: var(--brand-text) !important;
    }
    .main-bg:not(.bg_alt), .main-bg:not(.bg_alt) a, .main-bg:not(.bg_alt) p, .main-bg:not(.bg_alt) span {
        color: var(--brand-text) !important;
    }
    .main-bg .bg_alt *, .main-bg .bg_alt, .main-bg .bg_alt a, .main-bg .bg_alt p, .main-bg .bg_alt span{
        color: #000 !important;
    }

    .axil-product>.thumbnail .label-block .product-badget { padding: 6px 18px 5px; }

    /* ✅ Header compact */
    .axil-mainmenu .container-fluid{ padding-top: 6px !important; }
    .header-navbar{ padding-bottom: 4px; }

    @media only screen and (max-width: 991px) {
        .header-brand a img { max-height: 32px; width: 132px !important; }
        .brand_img { width: 60% !important; }
        .header_action { width: 21% !important; }
        .header-brand { text-align: center; }
    }
    @media only screen and (min-width: 767px) { .header-style-5 .axil-mainmenu { padding: 0px 0; } }

    .header-action>ul>li>a>i{ color: #000; }
    .mainmenu-nav a:hover { background-color: #f8f9fa; color: #0d6efd !important; }
    .mainmenu-nav .collapse a:hover { color: #0d6efd; padding-left: 8px; transition: all 0.2s ease-in-out; }

    /* ✅ sticky */
    .axil-mainmenu.axil-sticky{ z-index: 9999; }

    @media only screen and (max-width: 767px) {
        i[class^="flaticon-"]:before, i[class*=" flaticon-"]:before { color: black; font-size: 24px; }
        .topbar{ height: 40px; }
    }

    .cart-dropdown{ z-index: 99999; }
    .container-fluid{ max-width: 1600px; margin: 0 auto; }

    .cart-dropdown .cart-content-wrap{ width: 420px; right: -420px; }
    @media(max-width: 769px){
        .cart-dropdown .cart-content-wrap{ width: 320px; right: -320px; }
        .cart-dropdown{ width: 320px; right: -320px; }
    }

    /* ===========================
       ✅ LOGIN/REGISTER PREMIUM
       =========================== */
    .header-action .action-list,
    .header-action .action-list > li,
    .header-action .action-list > li.my-account{
        background: transparent !important;
    }
    .header-action .action-list > li{ display:flex; align-items:center; }

    .auth-btns{
        display:flex;
        align-items:center;
        gap:10px;
        flex-wrap:nowrap;
        white-space:nowrap;
    }
    .auth-btn{
        display:inline-flex;
        align-items:center;
        justify-content:center;
        padding:7px 16px;
        border-radius:999px;
        font-family:'Hind Siliguri', sans-serif;
        font-weight:800;
        font-size:14px;
        line-height:1;
        letter-spacing:.2px;
        text-decoration:none !important;
        border:1px solid transparent;
        box-shadow: 0 8px 18px rgba(2, 6, 23, .10);
        transition: transform .15s ease, box-shadow .15s ease, opacity .15s ease;
    }
    .auth-btn:hover{
        transform: translateY(-1px);
        box-shadow: 0 12px 26px rgba(2, 6, 23, .14);
    }
    .auth-btn.login{
        background:#fff;
        color:#0d6efd !important;
        border:1px solid rgba(13,110,253,.35);
        position:relative;
        overflow:hidden;
    }
    .auth-btn.login::before{
        content:"";
        position:absolute;
        inset:-2px;
        background: var(--brand-gradient);
        z-index:0;
        opacity:.95;
    }
    .auth-btn.login::after{
        content:"";
        position:absolute;
        inset:1px;
        background:#fff;
        border-radius:999px;
        z-index:1;
    }
    .auth-btn.login span{ position:relative; z-index:2; }
    .auth-btn.login:hover{ opacity:.95; }

    .auth-btn.register{
        background: var(--brand-gradient);
        color: var(--brand-text) !important;
        border: 1px solid rgba(255,255,255,.22);
    }
    .auth-btn.register:hover{ opacity:.92; }

    /* =========================================
       ✅ CALL & TRACK BUTTON (SAME STYLE & ANIMATION)
       ========================================= */
    
    /* ✅ এখানে .track-btn ক্লাসটি যোগ করা হলো */
    .phone-btn, .track-btn {
        width: 40px;
        height: 40px;
        display: flex;
        align-items: center;
        justify-content: center;
        border-radius: 50%;
        position: relative;
        z-index: 1;
        
        /* ✅ Dynamic Brand Background */
        background: var(--brand-gradient) !important;
        
        /* ✅ Fixed White Text/Icon Color */
        color: #ffffff !important;
        
        border: 1px solid rgba(255,255,255,.2);
        margin-left: 15px;
        text-decoration: none;
        box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        transition: all 0.3s ease;
    }

    /* ✅ Glow Animation Ring for Both Buttons */
    .phone-btn::before, .track-btn::before {
        content: '';
        position: absolute;
        top: 0; left: 0; right: 0; bottom: 0;
        border-radius: 50%;
        background: var(--brand-gradient); /* Same as button */
        z-index: -1;
        opacity: 0.6;
        animation: pulse-ring 2s infinite cubic-bezier(0.215, 0.61, 0.355, 1);
    }

    .phone-btn:hover, .track-btn:hover {
        transform: scale(1.05);
        filter: brightness(1.1);
        box-shadow: 0 6px 16px rgba(0,0,0,0.2);
        color: #ffffff !important;
    }
    
    /* Ensure icons are white */
    .phone-btn i, .track-btn i { 
        font-size: 16px; 
        color: #ffffff !important; 
    }

    @keyframes pulse-ring {
        0% { transform: scale(0.95); opacity: 0.7; }
        50% { opacity: 0.5; }
        100% { transform: scale(1.5); opacity: 0; }
    }

    @media (max-width: 1199px){
        .auth-btn{ padding:7px 14px; font-size:13px; }
        .auth-btns{ gap:8px; }
    }

    /* ===========================
       ✅ DESKTOP DROPDOWN
       =========================== */
    .desktopnav .nav-menu{
        list-style:none;
        padding:0;
        margin:0;
        display:flex;
        gap:4px;
        justify-content:center;
        align-items:center;
        flex-wrap:wrap;
    }
    .desktopnav .nav-menu > .nav-item{ position:relative; }

    @media (min-width: 992px){
        .desktopnav .nav-item.has-sub::after{
            content:"";
            position:absolute;
            left:0;
            top:100%;
            width:100%;
            height:12px;
            background:transparent;
        }
    }

    .desktopnav .nav-menu > .nav-item > .nav-link{
        display:inline-flex;
        align-items:center;
        gap:6px;
        padding:8px 14px;
        border-radius:999px;
        font-family:'Hind Siliguri', sans-serif;
        transition: transform .18s ease, background .18s ease, opacity .18s ease;
        color: var(--brand-text) !important;
        background: transparent;
        font-size: 16px !important;
        font-weight: 800;
        line-height: 1.1;
        text-decoration:none !important;
    }
    .desktopnav .nav-menu > .nav-item > .nav-link:hover{
        transform: translateY(-1px);
        background: rgba(255,255,255,.12);
    }

    .desktopnav .axil-submenu{
        list-style:none;
        margin:0;
        padding:6px 0;
        position:absolute;
        top: 100%;
        left: 0;
        margin-top: 6px;
        min-width: 220px;
        max-height: 320px;
        overflow-y: auto;

        background: var(--brand-gradient) !important;
        border: 1px solid rgba(255,255,255,.18);
        border-radius: 12px;
        box-shadow: 0 14px 32px rgba(0,0,0,.25);
        z-index: 999999;

        opacity: 0;
        transform: translateY(8px);
        visibility: hidden;
        pointer-events: none;
        transition: opacity .18s ease, transform .18s ease, visibility .18s ease;
        backdrop-filter: blur(10px);
    }
    .desktopnav .axil-submenu,
    .desktopnav .axil-submenu *{ color: var(--brand-text) !important; }

    .desktopnav .axil-submenu li a{
        display:block;
        padding:8px 12px;
        text-decoration:none;
        font-family:'Hind Siliguri', sans-serif;
        background: transparent !important;
        transition: background .15s ease, padding-left .15s ease, opacity .15s ease;
        border-left: 3px solid transparent;
        opacity: .95;
        font-size: 15px !important;
        font-weight: 700;
        line-height: 1.2;
        white-space: nowrap;
    }
    .desktopnav .axil-submenu li a:hover{
        background: rgba(0,0,0,.18) !important;
        border-left-color: rgba(255,255,255,.55);
        padding-left: 16px;
        opacity: 1;
    }

    @media (min-width: 992px){
        .desktopnav .nav-item:hover > .axil-submenu,
        .desktopnav .nav-item:focus-within > .axil-submenu{
            opacity: 1;
            transform: translateY(0);
            visibility: visible;
            pointer-events: auto;
        }
    }

    .desktopnav .nav-item.has-sub > .nav-link::after{
        content:"▾";
        font-size:12px;
        opacity:.95;
        margin-left:6px;
        color: var(--brand-text) !important;
    }

    .desktopnav.main-bg{ padding-top: 8px !important; padding-bottom: 8px !important; }
    @media (max-width: 991px){ .desktopnav{ display:none !important; } }

    /* ===========================
       ✅ TOPBAR NOTICE
       =========================== */
    .topbar { overflow: hidden; }
    .topbar .container-fluid{
        height: 40px !important;
        display:flex;
        align-items:center;
    }
    .topbar-notice{
        position: relative;
        width: 100%;
        height: 100%;
        display:flex;
        align-items:center;
        overflow:hidden;
        white-space: nowrap;
        padding-left: 0;
    }
    .topbar-notice .notice-track{
        display:inline-flex;
        align-items:center;
        gap: 40px;
        will-change: transform;
        animation: noticeScroll 90s linear infinite;
        padding-left: 100%;
    }
    .topbar-notice:hover .notice-track{ animation-play-state: paused; }
    .topbar-notice .notice-text{
        font-size: 16px;
        font-weight: 700;
        font-family:'Hind Siliguri', sans-serif;
        opacity: .98;
    }
    @keyframes noticeScroll{
        0%   { transform: translateX(0); }
        100% { transform: translateX(-100%) ; }
    }
    @media (max-width: 767px){
        .topbar-notice .notice-text{ font-size: 14px; }
    }

    /* ===========================
       ✅ SEARCH
       =========================== */
    .search-form{ width:100%; }
    .search-box{ position:relative; width:100%; }
    .search-box input{
        width:100% !important;
        height:50px !important;
        padding:0 18px 0 48px !important;
        border-radius: 32px !important;
        border:2px solid rgba(0,39,108,.35) !important;
        background:#fff !important;
        font-family:'Hind Siliguri', sans-serif !important;
        font-size:15px !important;
        font-weight:600 !important;
        color:#000 !important;
        outline:none !important;
        box-shadow:none !important;
        transition: all .25s ease !important;
    }
    .search-box input:focus{
        border-color:#00276C !important;
        box-shadow: 0 0 0 4px rgba(0,39,108,.18) !important;
    }
    .search-box input::placeholder{
        color:#000 !important;
        opacity:.70 !important;
        font-weight:600 !important;
    }
    .search-box .search-icon{
        position:absolute;
        left:18px;
        top:50%;
        transform:translateY(-50%);
        color:#00276C;
        font-size:16px;
        pointer-events:none;
    }
    .search-box:hover input{
        border-color: rgba(0,39,108,.55) !important;
        box-shadow:none !important;
    }
    @media(max-width:767px){
        .search-box input{
            height:46px !important;
            font-size:14px !important;
            padding-left:44px !important;
            border-radius: 28px !important;
        }
    }

    /* ✅ MOBILE: SEARCH OUTSIDE STICKY */
    .mobile-top-search-outside{
        display:none;
        padding: 10px 0 6px;
        background:#fff;
        border-bottom: 1px solid rgba(2,6,23,.08);
    }
    @media (max-width: 991px){
        .mobile-top-search-outside{ display:block; }
    }

    /* ✅ MOBILE MENU SCROLL */
    @media (max-width: 991px){
        .mainmenu-nav{
            display:flex;
            flex-direction:column;
            gap: 10px;
            max-height: calc(100vh - 110px);
            overflow-y:auto;
            -webkit-overflow-scrolling: touch;
        }
        .mainmenu-nav .menu-scroll{
            max-height: none !important;
            overflow: visible !important;
        }
    }

    /* ✅ Mobile category row */
    .mobile-cat-row{
        display:flex;
        align-items:center;
        background:#f8f9fa;
        border-radius: 10px;
        overflow:hidden;
    }
    .mobile-cat-row a{
        flex:1;
        padding: 14px 14px;
        text-decoration:none;
        color:#111 !important;
        font-weight:700;
        font-size:18px;
        font-family:'Hind Siliguri', sans-serif;
    }
    .mobile-cat-toggle{
        padding: 14px 14px;
        border:0;
        background:transparent;
    }
</style>

{{-- ✅ TOPBAR --}}
@if(isset($information) && $information->topbar_active == 1 && !empty($information->topbar_notice))
<div class="topbar main-bg">
    <div class="container-fluid position-relative" style="height:40px;display:flex;align-items:center;">
        <div class="topbar-notice w-100">
            <div class="notice-track">
                <span class="notice-text">{{ $information->topbar_notice }}</span>
                <span class="notice-text">{{ $information->topbar_notice }}</span>
            </div>
        </div>
    </div>
</div>
@endif

{{-- =======================
   ✅ DESKTOP HEADER
   ======================= --}}
<header class="desktop header axil-header header-style-5">
    <div id="axil-sticky-placeholder-desktop"></div>

    <div class="axil-mainmenu axil-mainmenu-desktop" style="background:#fff;">
        <div class="container-fluid" style="padding-top:6px;">
            <div class="row header-navbar">

                {{-- ✅ LEFT (logo) --}}
                <div class="col-4 d-flex desktop-left-col">
                    <div class="header-brand" style="margin-left:4%;height:44px;display:flex;align-items:center;">
                        <a href="{{ route('front.home')}}" class="logo logo-dark" style="width:190px;">
                            <img src="{{ asset('uploads/img/'.$information->site_logo)}}" alt="Site Logo" style="height:44px;width:190px;">
                        </a>
                        <a href="{{ route('front.home')}}" class="logo logo-light" style="width:190px;">
                            <img src="{{ asset('uploads/img/'.$information->site_logo)}}" alt="Site Logo" style="height:44px;width:190px;">
                        </a>
                    </div>
                </div>

                {{-- ✅ MIDDLE (desktop search) --}}
                <div class="col-4 desktop-search-col">
                    <form action="{{ route('front.products.index') }}" class="search-form">
                        <div class="search-box">
                            <i class="fas fa-search search-icon"></i>
                            <input type="search"
                                   id="search_desktop"
                                   name="q"
                                   value="{{ request('q') ?? '' }}"
                                   placeholder="What are you looking for..."
                                   autocomplete="off"
                                   maxlength="128">
                        </div>
                    </form>
                </div>

                {{-- ✅ RIGHT (auth + phone + cart) --}}
                <div class="col-4 desktop-right-col">
                    <div class="header-action">
                        <ul class="action-list">
                            @guest
                                <li class="my-account">
                                    <div class="auth-btns">
                                        <a href="{{ route('login') }}" class="auth-btn login"><span>Login</span></a>
                                        <a href="{{ route('register') }}" class="auth-btn register">Register</a>
                                    </div>
                                </li>
                            @else
                                <li class="my-account">
                                    <a href="{{ route('front.dashboard.index') }}" class="btn"
                                       style="background:#198754;border-radius:30px;padding:6px 16px;color:#fff;font-family:'Hind Siliguri', sans-serif;">
                                        {{ auth()->user()->first_name ? auth()->user()->first_name.' '.auth()->user()->last_name : auth()->user()->mobile }}
                                    </a>
                                </li>
                            @endguest
                            
                            {{-- ✅ NEW: ORDER TRACKING BUTTON (SAME STYLE AS CALL) --}}
                            <li class="track-action">
                                <a href="{{ route('front.order.track') }}" class="track-btn" title="Track Order">
                                    <i class="fas fa-truck"></i>
                                </a>
                            </li>

                            {{-- ✅ NEW DESKTOP CALL BUTTON (WHITE ICON) --}}
                            <li class="call-action">
                                <a href="tel:{{ $information->owner_phone }}" class="phone-btn" title="Call Us">
                                    <i class="fas fa-phone-alt"></i>
                                </a>
                            </li>

                            <li class="shopping-cart">
                                <a href="{{ route('front.carts.index')}}?segment={{request()->segment(1)}}"
                                   style="font-family:'Hind Siliguri', sans-serif;" class="cart-dropdown-btn">
                                    <span class="cart-count" style="background:#00276C !important;font-family:'Hind Siliguri', sans-serif">
                                        {{ getTotalCart()}}
                                    </span>
                                    <i class="flaticon-shopping-cart"></i>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>

            </div>
        </div>

        {{-- ✅ DESKTOP CATEGORY NAV --}}
        <div class="desktopnav main-bg" style="border-bottom:1px solid #f2f2f2;">
            <div class="container-fluid">
                <ul class="nav-menu">
                    @foreach($categories as $cat)
                        <li class="nav-item {{ $cat->subcats->count() ? 'has-sub' : '' }}">
                            <a href="{{ route('front.subCategories1',[$cat->url])}}" class="nav-link">
                                {{ $cat->name }}
                            </a>

                            @if($cat->subcats->count())
                                <ul class="axil-submenu">
                                    @foreach($cat->subcats as $sub)
                                        <li>
                                            <a href="{{ route('front.subsubCategories',[$sub->url])}}">
                                                {{ $sub->name }}
                                            </a>
                                        </li>
                                    @endforeach
                                </ul>
                            @endif
                        </li>
                    @endforeach
                </ul>
            </div>
        </div>

    </div>
</header>

{{-- =======================
   ✅ MOBILE HEADER
   ======================= --}}
<header class="mobile header axil-header header-style-5 bg-light">
    <div id="axil-sticky-placeholder-mobile"></div>

    <div class="axil-mainmenu axil-mainmenu-mobile" style="background-color:#fff;">
        <div class="container">

            {{-- TOP ROW --}}
            <div class="row align-items-center">
                <div class="col-2">
                    <ul class="mainmenu">
                        <li class="axil-mobile-toggle mt-0">
                            <button class="menu-btn mobile-nav-toggler text-dark">
                                <i class="fas fa-bars" style="color:black;"></i>
                            </button>
                        </li>
                    </ul>
                </div>

                <div class="col-4 brand_img">
                    <div class="header-brand">
                        <a href="{{ route('front.home')}}" class="logo logo-dark">
                            <img src="{{ asset('uploads/img/'.$information->site_logo)}}" alt="Site Logo">
                        </a>
                        <a href="{{ route('front.home')}}" class="logo logo-light">
                            <img src="{{ asset('uploads/img/'.$information->site_logo)}}" alt="Site Logo">
                        </a>
                    </div>
                </div>

                <div class="col-6 header_action">
                    <div class="header-action">
                        <ul class="action-list">
                            {{-- ❌ MOBILE CALL BUTTON REMOVED --}}
                            
                            <li class="shopping-cart">
                                <a href="{{ route('front.carts.index')}}?segment={{request()->segment(1)}}" class="cart-dropdown-btn">
                                    <span class="cart-count" style="background:#00276C !important;">
                                        {{ getTotalCart()}}
                                    </span>
                                    <i class="flaticon-shopping-cart" style="color:black;"></i>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>

            {{-- MOBILE DRAWER CONTENT --}}
            <div class="header-navbar">
                <div class="header-main-nav">
                    <nav class="mainmenu-nav bg-white shadow-sm rounded-3 p-3">

                        <div class="d-flex flex-column mb-2">
                            <a href="{{ route('front.home') }}" class="logo d-flex align-items-center text-decoration-none mb-2">
                                <img src="{{ asset('uploads/img/'.$information->site_logo) }}" alt="Site Logo" class="me-2" style="height:40px;">
                            </a>

                            <div class="my-account mb-2">
                                @guest
                                    <a href="{{ route('login') }}" class="auth-btn login w-100 mb-2 text-center"><span>Login</span></a>
                                    <a href="{{ route('register') }}" class="auth-btn register w-100 text-center">Register</a>
                                @else
                                    <a href="{{ route('front.dashboard.index') }}" class="btn btn-success btn-sm w-100">
                                        {{ auth()->user()->first_name ? auth()->user()->first_name.' '.auth()->user()->first_name.' '.auth()->user()->last_name : auth()->user()->mobile }}
                                    </a>
                                @endguest
                            </div>
                        </div>

                        <ul class="list-unstyled m-0 menu-scroll">
                            {{-- ✅ Mobile Menu তে Order Track যুক্ত করা হলো --}}
                            <li class="mb-1 d-block">
                                <a href="{{ route('front.order.track') }}" 
                                   class="d-block p-3 bg-light rounded text-decoration-none text-dark"
                                   style="font-size:18px;font-weight:700;font-family:'Hind Siliguri', sans-serif;">
                                   <i class="fas fa-truck me-2"></i> Track Order
                                </a>
                            </li>

                            @foreach($categories as $key => $cat)
                                @php
                                    $hasSub = $cat->subcats->count() > 0;
                                    $collapseId = "collapseCat_".$key;
                                @endphp

                                <li class="mb-1 d-block">
                                    @if($hasSub)
                                        <div class="mobile-cat-row">
                                            <a href="{{ route('front.subCategories1', [$cat->url]) }}">
                                                {{ $cat->name }}
                                            </a>
                                            <button class="mobile-cat-toggle"
                                                    type="button"
                                                    data-bs-toggle="collapse"
                                                    data-bs-target="#{{ $collapseId }}"
                                                    aria-expanded="false"
                                                    aria-controls="{{ $collapseId }}">
                                                <i class="fas fa-chevron-down small"></i>
                                            </button>
                                        </div>

                                        <div class="collapse mt-1" id="{{ $collapseId }}">
                                            <ul class="list-unstyled ps-3">
                                                @foreach($cat->subcats as $sub)
                                                    <li class="py-1">
                                                        <a href="{{ route('front.subsubCategories', [$sub->url]) }}"
                                                           class="text-decoration-none text-secondary d-block py-2">
                                                            <i class="fas fa-angle-right me-1"></i>{{ $sub->name }}
                                                        </a>
                                                    </li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    @else
                                        <a href="{{ route('front.subCategories1', [$cat->url]) }}"
                                           class="d-block p-3 bg-light rounded text-decoration-none text-dark"
                                           style="font-size:18px;font-weight:700;font-family:'Hind Siliguri', sans-serif;">
                                            {{ $cat->name }}
                                        </a>
                                    @endif
                                </li>
                            @endforeach
                        </ul>

                    </nav>
                </div>
            </div>

        </div>
    </div>
</header>

{{-- ✅ MOBILE SEARCH (OUTSIDE HEADER => NOT STICKY) --}}
<div class="mobile-top-search-outside">
    <div class="container">
        <form action="{{ route('front.products.index') }}" class="search-form">
            <div class="search-box">
                <i class="fas fa-search search-icon"></i>
                <input type="search"
                       id="search_mobile"
                       name="q"
                       value="{{ request('q') ?? '' }}"
                       placeholder="What are you looking for..."
                       autocomplete="off"
                       maxlength="128">
            </div>
        </form>
    </div>
</div>

{{-- ✅ Fixed Cart Bottom --}}
<a href="{{ route('front.carts.index')}}?segment={{request()->segment(1)}}" class="cart-dropdown-btn">
    <div class="fixed-cart-bottom">
        <p class="main-bg" style="border-top-left-radius:12px;border-top-right-radius:12px;">
            <i class="fas fa-shopping-cart" style="color:#ffffff !important;"></i>
        </p>
        <p class="main-bg cart-count" style="color:white;font-size:10px;">
           @if(getTotalCart() > 1) {{ getTotalCart()}} items @else {{ getTotalCart()}} item @endif
        </p>
        <p style="color:white;font-size:10px;background:#00276C;border-bottom-left-radius:12px;border-bottom-right-radius:12px;" class="cart-amount">
            ৳ {{ getTotalAmount() }}
        </p>
    </div>
</a>

{{-- ✅ WhatsApp --}}
@if($information->whats_active == '1')
<a href="https://wa.me/+88{{ $information->whats_num }}" target="_blank" class="whats_btn">
    <span>
       <img width="60px" height="60px" src="https://img.icons8.com/color/48/whatsapp--v1.png" alt="whatsapp--v1"/>
    </span>
</a>
@endif

<script src="https://code.jquery.com/jquery-3.7.1.min.js"
        integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo="
        crossorigin="anonymous"></script>

<script>
/**
 * ✅ Sticky: Desktop header only
 * - Desktop sticky => search থাকবে
 * - Placeholder height fix
 */
$(function(){

  var $menu = $('.axil-mainmenu-desktop').first();
  var $ph   = $('#axil-sticky-placeholder-desktop').first();

  if(!$menu.length) return;

  function setPlaceholder(){
    if($menu.hasClass('axil-sticky')){
      $ph.height($menu.outerHeight());
    }else{
      $ph.height(0);
    }
  }

  var stickyTop = $menu.offset().top;

  function onScroll(){
    var st = $(window).scrollTop();

    if(st > stickyTop){
      if(!$menu.hasClass('axil-sticky')){
        $menu.addClass('axil-sticky').css({
          position:'fixed', top:0, left:0, right:0, width:'100%',
          boxShadow:'0 10px 24px rgba(0,0,0,.08)'
        });
        setPlaceholder();
      }
    }else{
      if($menu.hasClass('axil-sticky')){
        $menu.removeClass('axil-sticky').attr('style','background:#fff;');
        setPlaceholder();
      }
    }
  }

  onScroll();
  $(window).on('scroll', onScroll);

  $(window).on('resize', function(){
    stickyTop = $menu.offset().top;
    setPlaceholder();
    onScroll();
  });

});
</script>