{{-- resources/views/frontend/products/partials/product_section.blade.php --}}

@php
    $data = getProductInfo($product);

    use App\Models\Information;
    use App\Models\BanglaText;
    use App\Models\AdminText;
    use App\Models\Variation;
    use App\Models\ProductStock;

    $info = Information::first();
    $bangla_text = BanglaText::first();
    $dt = AdminText::first();

    $curr = $info->currency ?? 'BDT';

    // ✅ Texts
    $addToCartText = $dt->add_to_cart_text ?? 'কার্টে যোগ করুন';
    $orderNowText  = $dt->order_now_text ?? 'অর্ডার করুন';
    $fshipText = $bangla_text->fshipping_text ?? 'Free Shipping';

    $productParam = $product->slug ?: $product->id;

    $variationId = optional($product->variation)->id
        ?? optional($product->variations->first())->id
        ?? Variation::where('product_id', $product->id)->orderBy('id','asc')->value('id');

    // ✅ Stock logic
    $productStock   = (int)($product->stock_quantity ?? 0);
    $isStockEnabled = (int)($product->is_stock ?? 0) === 1;

    $variationStock = 0;
    if($product->type === 'single' && $isStockEnabled && (int)$variationId > 0){
        $variationStock = (int) ProductStock::where('variation_id', (int)$variationId)->sum('quantity');
    }

    $qtySource = ($product->type === 'single' && $isStockEnabled && (int)$variationId > 0)
        ? $variationStock
        : $productStock;

    $isOut = ($product->type === 'single') && ( $isStockEnabled ? ($qtySource <= 0) : ($productStock <= 0) );

    $finalPrice = ((float)($product->after_discount ?? 0) > 0)
        ? (float)$product->after_discount
        : (float)($product->sell_price ?? 0);

    $segm = request()->segment(1) ?? 'home';
    if(in_array($segm, ['checkout','cart','carts','order','orders'], true)) $segm = 'home';

    $pSlug = $product->slug ?? null;
@endphp

@once
<style>
    :root{
        --primary:#00276C;
        --primary-soft:rgba(0,39,108,.18);
        --primary-mid:rgba(0,39,108,.28);
        --primary-strong:rgba(0,39,108,.40);
    }

    /* ✅ CARD STYLE */
    .axil-product.product-style-one{
        border-radius: 22px !important;
        overflow: hidden !important;
        background: #fff !important;
        border: 1px solid rgba(0,39,108,0.06) !important;
        box-shadow: 0 4px 20px rgba(0,0,0,0.03), 0 1px 3px rgba(0,0,0,0.02) !important;
        transition: all 0.4s cubic-bezier(0.25, 0.8, 0.25, 1) !important;
        position: relative !important;
        height: 100%;
        display: flex;
        flex-direction: column;
    }

    .axil-product .thumbnail{
        border-radius: 22px 22px 0 0 !important;
        overflow: hidden !important;
        background: linear-gradient(180deg, rgba(0,39,108,.03), rgba(255,255,255,0)) !important;
        position: relative !important;
    }

    .axil-product .thumbnail img.product_img{
        width: 100% !important;
        height: auto !important;
        object-fit: cover !important;
        border-radius: 18px !important;
        transition: transform .5s ease, filter .5s ease !important;
        display:block;
    }

    /* Desktop Hover Effects */
    @media (min-width: 992px) {
        .axil-product.product-style-one:hover{
            transform: translateY(-8px) !important;
            border-color: transparent !important;
            box-shadow: 0 25px 50px -12px rgba(0,39,108,0.18), 0 10px 15px -5px rgba(0,39,108,0.08) !important;
            background: #fff !important;
            z-index: 2;
        }
        .axil-product.product-style-one:hover .thumbnail img.product_img{
            transform: scale(1.08) !important;
            filter: saturate(1.02) contrast(1.01);
        }
        .axil-product .desktop-cart button.btn:hover:not(.is-disabled):not([disabled]),
        .axil-product .desktop-cart .reg:hover{
            transform: translateY(-3px) !important;
            box-shadow: 0 15px 35px rgba(0,39,108,.3) !important;
            filter: saturate(1.05) brightness(1.05) !important;
        }
        .axil-product .bottom-icon-btn:hover{
            transform: translateY(-3px) scale(1.05) !important;
            box-shadow: 0 10px 25px rgba(0,39,108,.25) !important;
            background: var(--primary) !important;
            color:#fff !important;
        }
    }

    .axil-product .label-block.label-right{
        position: absolute !important;
        top: 12px !important;
        right: 12px !important;
        z-index: 6 !important;
        display: flex !important;
        flex-direction: column !important;
        gap: 6px !important;
    }

    .axil-product .product-badget{
        border-radius: 999px !important;
        padding: 6px 12px !important;
        font-weight: 800 !important;
        letter-spacing: .2px !important;
        box-shadow: 0 4px 10px rgba(0,0,0,0.1) !important;
        border: 1px solid rgba(255,255,255,.5) !important;
        font-family: 'Hind Siliguri', sans-serif !important;
    }

    .axil-product .product-content{ padding: 10px 10px 0 10px !important; }

    .axil-product .product-content .title{
        margin: 8px 0 10px 0 !important;
        line-height: 1.25 !important;
        font-weight: 900 !important;
        font-size: 16px !important;
    }

    .axil-product .product-content .title a{
        color: #0b1b3a !important;
        text-decoration: none !important;
        display: -webkit-box !important;
        -webkit-line-clamp: 2 !important;
        -webkit-box-orient: vertical !important;
        overflow: hidden !important;
        min-height: 40px !important;
        font-family: 'Hind Siliguri', sans-serif !important;
    }

    .axil-product .product-price-variant{
        display: flex !important;
        justify-content: center !important;
        align-items: baseline !important;
        gap: 10px !important;
        padding-bottom: 6px !important;
    }
    .axil-product .product-price-variant .current-price{
        font-size: 18px !important;
        font-weight: 900 !important;
    }
    .axil-product .product-price-variant .old-price{
        font-size: 14px !important;
        text-decoration: line-through !important;
    }

    .axil-product .bottom-icons-row{
        display:flex !important;
        align-items:center !important;
        justify-content: space-between !important;
        gap: 10px !important;
        padding: 6px 10px 10px 10px !important;
    }
    .axil-product .bottom-icon-btn{
        width: 44px !important; height: 44px !important;
        border-radius: 999px !important;
        display:inline-flex !important;
        align-items:center !important;
        justify-content:center !important;
        border: 1px solid rgba(0,39,108,.1) !important;
        background: #fff !important;
        box-shadow: 0 5px 15px rgba(0,39,108,.08) !important;
        color: var(--primary) !important;
        cursor:pointer !important;
        transition: transform .22s ease, box-shadow .22s ease, background .22s ease, color .22s ease !important;
        text-decoration:none !important;
        padding:0 !important;
    }

    .axil-product .bottom-icon-btn.is-disabled,
    .axil-product .desktop-cart button.btn.is-disabled{
        opacity: .45 !important;
        cursor: not-allowed !important;
        pointer-events: none !important;
        box-shadow: none !important;
    }

    .axil-product .desktop-cart{
        margin-top: auto;
        padding: 0 14px 14px 14px !important;
    }

    /* ✅ BUTTON DESIGN FIXED FOR CENTERING */
    .axil-product .desktop-cart button.btn,
    .axil-product .desktop-cart .reg{
        border-radius: 16px !important;
        overflow: hidden !important;
        height: 46px !important;
        display: flex !important;
        align-items: center !important;
        justify-content: center !important; 
        text-align: center !important;
        font-weight: 900 !important;
        box-shadow: 0 8px 20px rgba(0,39,108,.15) !important;
        border: none !important;
        width: 100% !important;
        padding: 0 !important; /* Force Remove Padding */
        transition: transform .22s ease, box-shadow .22s ease, filter .22s ease !important;
        will-change: transform;
        color: #fff !important; 
        background: #00276C; 
    }

    /* P Tag Styling - Explicit Centering */
    .axil-product .desktop-cart button.btn p{ 
        margin: 0 !important; 
        padding: 0 !important;
        width: 100% !important; 
        line-height: 1 !important;
        text-align: center !important; 
        display: flex !important;      
        justify-content: center !important; 
        align-items: center !important;     
    }
     
    .axil-product .desktop-cart button.btn b{
        display: flex !important; 
        align-items: center !important; 
        justify-content: center !important;
        gap: 6px !important;
        margin: 0 !important;
        font-family: 'Hind Siliguri', sans-serif !important; 
        font-weight: 900 !important; 
        font-size: 14px !important;
    }

    .axil-product .desktop-cart .reg a{
        width: 100% !important;
        display: flex !important;
        align-items: center !important;
        justify-content: center !important;
        height: 100% !important;
        color: #fff !important;
        text-decoration: none !important;
        white-space: nowrap !important;
        font-family: 'Hind Siliguri', sans-serif !important;
        font-weight: 900 !important;
        font-size: 14px !important;
        text-align: center !important;
    }

    /* 🔴 IOS FIX: Pointer Events */
    .axil-product .desktop-cart button.btn * {
        pointer-events: none !important;
    }
    .axil-product .desktop-cart button.btn {
        touch-action: manipulation;
    }
</style>
@endonce

<div class="axil-product product-style-one" data-is-out="{{ $isOut ? 1 : 0 }}" style="padding:0 !important;">
    <div class="thumbnail" style="padding:10px !important">
        <a href="{{ route('front.products.show', ['product' => $productParam]) }}">
            <img src="{{ getImage('thumb_products', $product->image) }}" class="product_img" alt="Product Images">
        </a>

        @if(($product->after_discount ?? 0) > 0 || ($isOut && $product->type==='single'))
            <div class="label-block label-right">
                @if(($product->after_discount ?? 0) > 0)
                    @php
                        $price = (float)($product->sell_price ?? 0);
                        $afterDiscount = (float)($product->after_discount ?? 0);
                        $discountAmount = $price - $afterDiscount;
                        $discountPercent = $price > 0 ? round(($discountAmount / $price) * 100, 0) : 0;
                    @endphp
                    <div class="product-badget" style="background:#00276C;color:#FFC610;">
                        {{ $discountPercent }} % Off
                    </div>
                @endif
                @if($isOut && $product->type==='single')
                    <div class="product-badget mt-1" style="background:#c10c0c;color:#fff;">
                        STOCK OUT
                    </div>
                @endif
            </div>
        @endif
    </div>

    <div class="product-content" style="padding:10px !important; padding-top:0 !important;">
        <div class="inner">
            <h5 class="title text-center">
                <a href="{{ route('front.products.show', ['product' => $productParam]) }}">
                    {{ $product->name }}
                </a>
            </h5>

            <div class="product-price-variant text-center">
                <span class="price current-price" style="color:#00276C;font-family:'Hind Siliguri', sans-serif">
                    @if($curr == 'BDT') ৳ {{ (int)($data['price'] ?? 0) }}
                    @elseif($curr == 'Dollar') $ {{ $data['price'] ?? 0 }}
                    @elseif($curr == 'Euro') {{ $data['price'] ?? 0 }}
                    @elseif($curr == 'Rupee') {{ $data['price'] ?? 0 }}
                    @endif
                </span>

                @if(($product->after_discount ?? 0) > 0)
                    <span class="price old-price" style="color:#c2050b;font-family:'Hind Siliguri', sans-serif; opacity:.7;">
                        @if($curr == 'BDT') {{ (int)($data['old_price'] ?? 0) }}
                        @elseif($curr == 'Dollar') $ {{ $data['old_price'] ?? 0 }}
                        @elseif($curr == 'Euro') {{ $data['old_price'] ?? 0 }}
                        @elseif($curr == 'Rupee') {{ $data['old_price'] ?? 0 }}
                        @endif
                    </span>
                @endif
            </div>

            <div class="bottom-icons-row">
                @if($product->type === "single")
                    <button type="button"
                            class="bottom-icon-btn js-add-to-cart-icon {{ $isOut ? 'is-disabled' : '' }}"
                            title="{{ $isOut ? 'Stock Out' : $addToCartText }}">
                        <i class="fas fa-shopping-cart"></i>
                    </button>
                @else
                    <a href="{{ route('front.products.show', ['product' => $productParam]) }}"
                       class="bottom-icon-btn"
                       title="Select Options">
                        <i class="fas fa-layer-group"></i>
                    </a>
                @endif

                <button type="button"
                        class="bottom-icon-btn js-quickview-open"
                        title="Quick View"
                        data-popup-url="{{ route('front.product.popup', $product->id) }}"
                        data-bs-toggle="modal"
                        data-bs-target="#quick-view-modal">
                    <i class="far fa-eye"></i>
                </button>
            </div>
        </div>
    </div>

    {{-- ✅ Bottom Order Button --}}
    @if($product->type === "single")
        <form method="POST" action="{{ route('front.carts.store') }}">
            @csrf
            <input type="hidden" name="segment" value="{{ $segm }}">
            <input type="hidden" name="product_slug" value="{{ $pSlug }}">
            <input type="hidden" name="product_id" value="{{ $product->id }}">
            <input type="hidden" name="variation_id" value="{{ (int)($variationId ?? 0) }}">
            <input type="hidden" name="quantity" value="1">
            <input type="hidden" name="qty" value="1">
            <input type="hidden" name="price" value="{{ $finalPrice }}">
            <input type="hidden" name="is_stock" value="{{ $product->is_stock ?? 0 }}">
            <input type="hidden" name="action_type" value="order">

            <div class="desktop-cart" style="padding-bottom:0;">
                {{-- 🔴 FIXED: Removed 'col-12', added 'w-100' for perfect centering --}}
                <button type="button"
                        onclick="manualOrder(this)"
                        class="btn p-0 button m-auto w-100 main-bg {{ $isOut ? 'is-disabled' : '' }}"
                        {{ $isOut ? 'disabled' : '' }}>
                    @if(($product->is_free_shipping ?? 0) == 0)
                        <p><b><i class="fas fa-shopping-cart"></i> &nbsp; {{ $orderNowText }}</b></p>
                    @else
                        <p><b><i class="fas fa-shopping-cart"></i> &nbsp; {{ $fshipText }}</b></p>
                    @endif
                </button>
            </div>
        </form>
    @else
        <div class="desktop-cart">
            <div class="product-add-to-cart">
                <ul class="cart-action" style="padding:0;margin:0;list-style:none;">
                    <li class="col-12 reg text-center main-bg" style="padding:7px;border-radius:16px;text-align:center;">
                        <a href="{{ route('front.products.show', ['product' => $productParam]) }}">
                            <i class="fas fa-shopping-cart"></i> &nbsp; {{ $orderNowText }}
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    @endif
</div>

@once
@push('js')
<script>
// 🔴 GLOBAL FUNCTION: Manual Order to fix iOS Issue
function manualOrder(btn) {
    if(!btn) return;
    
    // Check disabled state via class or attribute
    if(btn.classList.contains('is-disabled') || btn.disabled) return;

    var form = btn.closest('form');
    if(!form) return;

    // Loading State
    btn.classList.add('is-disabled');
    btn.disabled = true;
    var icon = btn.querySelector('i');
    if(icon) icon.className = 'fas fa-spinner fa-spin';

    // Direct Submit
    form.submit();
}

(function(){
  if(window.__BC_CARD_CART_ICON_INIT__) return;
  window.__BC_CARD_CART_ICON_INIT__ = true;

  function toastError(msg){
    if(window.toastr) toastr.error(msg); else alert(msg);
  }
  function toastSuccess(msg){
    if(window.toastr) toastr.success(msg);
  }
  function getCsrf(){
    const meta = document.querySelector('meta[name="csrf-token"]');
    return meta && meta.getAttribute('content') ? meta.getAttribute('content') : (document.querySelector('input[name="_token"]')?.value || '');
  }
  function isOut(card){
    return String(card?.getAttribute('data-is-out') || '0') === '1';
  }
  function outMsg(){ toastError('দুঃখিত! এই প্রোডাক্টটি স্টক আউট।'); }
  function getCartContainer(){
    return document.querySelector('#cart-dropdown') || document.querySelector('#cart_section');
  }

  function openCartSidebar(){
    if(typeof window.__openCartSidebar === 'function'){ try{ window.__openCartSidebar(); return true; }catch(e){} }
    const triggers = ['.cart-dropdown-btn', '.cart-btn', '.header-action .cart', '.header-cart', '.cart-toggle', '[data-cart-open]'];
    for(const sel of triggers){
      const el = document.querySelector(sel);
      if(el && typeof el.click === 'function'){ el.click(); return true; }
    }
    const box = getCartContainer();
    if(box){ box.classList.add('open','active','show'); document.body.classList.add('cart-open'); return true; }
    return false;
  }

  async function ajaxAddToCart(form){
    const fd = new FormData(form);
    fd.set('action_type','cart');
    fd.set('quantity','1'); 
    fd.set('qty','1'); 
    fd.set('segment','home');
    
    const r = await fetch(form.action, {
      method: 'POST',
      credentials: 'same-origin',
      headers: { 'X-Requested-With': 'XMLHttpRequest', 'X-CSRF-TOKEN': getCsrf(), 'Accept': 'application/json' },
      body: fd
    });
    
    const ct = (r.headers.get('content-type') || '').toLowerCase();
    if(ct.includes('application/json')){ return { ok: r.ok, status: r.status, res: await r.json().catch(()=>({})) }; }
    return { ok: r.ok, status: r.status, res: null, text: await r.text().catch(()=>'') };
  }

  // Listener for CART ICON only
  document.addEventListener('click', async function(e){
    const btn = e.target.closest('.js-add-to-cart-icon');
    if(!btn) return;
    e.preventDefault();
    const card = btn.closest('.axil-product');
    if(!card) return;
    if(isOut(card)){ outMsg(); return; }
    const form = card.querySelector('form');
    if(!form) return;

    btn.classList.add('is-disabled');
    try{
      const result = await ajaxAddToCart(form);
      btn.classList.remove('is-disabled');
      if(result.res && result.res.success){
          toastSuccess(result.res.msg || 'Added to cart');
          const box = getCartContainer();
          if(result.res.html && box) box.innerHTML = result.res.html;
          else if(result.res.cart_html && box) box.innerHTML = result.res.cart_html;
          
          if(result.res.item !== undefined) document.querySelectorAll('.cart-count').forEach(el => el.textContent = result.res.item);
          if(result.res.amount !== undefined) document.querySelectorAll('.cart-amount').forEach(el => el.textContent = '৳ ' + result.res.amount);
          
          openCartSidebar();
          document.dispatchEvent(new CustomEvent('cart:updated'));
      } else {
          toastError(result.res?.msg || 'Something went wrong!');
      }
    }catch(err){
      btn.classList.remove('is-disabled');
    }
  }, true);

})();
</script>
@endpush
@endonce