@extends('frontend.app')

@php
    use App\Models\Information;
    use App\Models\BanglaText;
    use App\Models\Page;
    use App\Models\ProductStock;
    use App\Models\AdminText;

    $aboutUs        = Page::where('page','about')->first();
    $termsCondition = Page::where('page','term')->first();
    $info           = Information::first();
    $bangla_text    = BanglaText::first();
    
    // ডাটা লোড
    $singleProduct->loadMissing(['variations.size','variations.color','variations.stocks']);

    $dt = AdminText::first();

    /* Default rows settings */
    $DEFAULT_SIZE_ID  = 3; 
    $DEFAULT_COLOR_ID = 1;

    $varMap   = [];
    $sizesMap = [];
    $colorsMap= [];

    // ১. ভ্যারিয়েশন থাকলে ম্যাপ তৈরি
    if($singleProduct->variations && $singleProduct->variations->count() > 0){
        foreach($singleProduct->variations as $v){
            $sid = (int)($v->size_id ?? 0);
            $cid = (int)($v->color_id ?? 0);

            $sizeLabel  = $v->size_label  ?? optional($v->size)->name ?? ($v->size ?? 'Default');
            $colorLabel = $v->color_label ?? optional($v->color)->name ?? ($v->color ?? 'Default');

            if($sid !== $DEFAULT_SIZE_ID) $sizesMap[$sid]  = $sizeLabel;
            if($cid !== $DEFAULT_COLOR_ID) $colorsMap[$cid] = $colorLabel;

            $base  = (float)($v->price ?? 0);
            $after = (float)($v->after_discount_price ?? 0);
            $disc  = (float)($v->discount_price ?? 0);

            if($after > 0 && $after < $base) $final = $after;
            elseif($disc > 0 && $disc < $base) $final = $disc;
            else $final = $base;

            $stock = (int)($v->stocks ? $v->stocks->sum('quantity') : 0);

            $key = $sid.'|'.$cid;
            $varMap[$key] = [
                'id' => (int)$v->id,
                'size_id' => $sid,
                'color_id'=> $cid,
                'size' => $sizeLabel,
                'color'=> $colorLabel,
                'raw'  => $base,
                'price'=> $final,
                'stock'=> $stock,
            ];
        }
    }

    // ২. ডিফল্ট ভ্যারিয়েশন সেট
    $defaultVar = $singleProduct->variations->first();
    if($defaultVar){
        foreach($singleProduct->variations as $v){
            if(!empty($v->is_default) && (int)$v->is_default === 1){
                $defaultVar = $v; break;
            }
        }
    }
    
    $defaultSizeId  = (int)($defaultVar->size_id ?? 0);
    $defaultColorId = (int)($defaultVar->color_id ?? 0);

    // ৩. [FIX] সিম্পল প্রোডাক্ট হ্যান্ডেলিং (যদি varMap খালি থাকে)
    if(count($varMap) === 0) {
        $key = $DEFAULT_SIZE_ID.'|'.$DEFAULT_COLOR_ID;
        
        $mPrice = $singleProduct->sell_price;
        $mAfter = $singleProduct->after_discount;
        $mFinal = ($mAfter > 0 && $mAfter < $mPrice) ? $mAfter : $mPrice;

        $varMap[$key] = [
            'id'       => null, 
            'size_id'  => $DEFAULT_SIZE_ID,
            'color_id' => $DEFAULT_COLOR_ID,
            'size'     => 'Regular',
            'color'    => 'Regular',
            'raw'      => (float)$mPrice,
            'price'    => (float)$mFinal,
            'stock'    => (int)$singleProduct->stock_quantity,
        ];
        
        $defaultSizeId  = $DEFAULT_SIZE_ID;
        $defaultColorId = $DEFAULT_COLOR_ID;
    }

    $initialKey = $defaultSizeId.'|'.$defaultColorId;
    $initialVar = $varMap[$initialKey] ?? (count($varMap) ? reset($varMap) : null);

    $initialStock = $initialVar ? (int)($initialVar['stock'] ?? 0) : (int)($singleProduct->stock_quantity ?? 0);
    $inStock = ($initialStock > 0);

    $curr = $info->currency;

    $initFinal = (float)($initialVar['price'] ?? ($singleProduct->after_discount > 0 ? $singleProduct->after_discount : $singleProduct->sell_price));
    $initRaw   = (float)($initialVar['raw']   ?? ($singleProduct->sell_price ?? 0));

    $showSize  = count($sizesMap)  > 0;
    $showColor = count($colorsMap) > 0;
@endphp

@push('css')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css"/>

<style>
    :root{
      --brand-gradient: {!! $info->gradient_code ?? 'linear-gradient(90deg,#0d6efd,#00276C)' !!};
      --brand-text: {{ $info->primary_color ?? '#ffffff' }};
      --brand-dark: #00276C;

      --bg: #f6f9ff;
      --card: #ffffff;
      --text: #0f172a;
      --muted: #64748b;

      --border: rgba(2,6,23,.10);
      --border2: rgba(2,6,23,.14);

      --shadow: 0 18px 50px rgba(0,39,108,.10);
      --shadow2: 0 12px 28px rgba(0,0,0,.08);
      --shadowHover: 0 24px 60px rgba(0,39,108,.14);

      --radius: 16px;
      --radius2: 18px;

      --success: #16a34a;
      --danger: #ef4444;
      --warn: #f59e0b;

      --t: .25s ease;
    }

    .bg-color-white{ background: var(--bg) !important; }
    .axil-single-product-area{ background: var(--bg) !important; }

    .animated_text{ font-size: 16px; transition: all var(--t); }
    .animated_text:hover{ transform: translateY(-1px); filter: brightness(1.02); }

    @media (min-width: 992px){
      .details_right{ margin-left: 14px; }
    }
    .details-price{ margin-bottom: 14px !important; }

    .details_right{
      border: 1px solid var(--border) !important;
      background: linear-gradient(180deg, rgba(0,39,108,.03), rgba(255,255,255,1));
      padding: 16px 18px;
      height: 100%;
      border-radius: var(--radius2);
      box-shadow: var(--shadow2);
      position: relative;
      overflow: hidden;
    }
    .details_right:before{
      content:"";
      position:absolute; inset:0;
      background: radial-gradient(700px 180px at 20% 0%, rgba(13,110,253,.10), transparent 55%),
                  radial-gradient(520px 160px at 90% 10%, rgba(0,39,108,.10), transparent 60%);
      pointer-events:none;
      opacity:.85;
    }
    .details_right > *{ position: relative; z-index: 1; }

    .product-cart .name{
      font-size: 20px;
      font-weight: 800;
      text-transform: capitalize;
      color: var(--text);
      letter-spacing: .2px;
      line-height: 1.25;
      margin-bottom: 8px;
    }

    .details-price{
      font-size: 20px;
      font-weight: 800;
      color: var(--text);
      margin: 8px 0 10px;
      display:flex;
      flex-wrap:wrap;
      align-items: baseline;
      gap: 10px;
    }
    .details-price del{
      color: rgba(148,163,184,1);
      font-size: 15px;
      font-weight: 700;
    }
    .current-price-product{
      background: rgba(0,39,108,.06);
      border: 1px solid rgba(0,39,108,.12);
      padding: 4px 12px;
      border-radius: 999px;
      font-size: 16px;
    }

    .badge{
      border-radius: 999px !important;
      padding: 7px 12px !important;
      font-weight: 800 !important;
      letter-spacing: .2px;
      box-shadow: 0 8px 18px rgba(0,0,0,.08);
      font-size: 13px !important;
    }

    .details-ratting-wrapper{
      margin: 8px 0 10px;
      display:flex;
      align-items:center;
      flex-wrap:wrap;
      gap: 8px;
      padding: 10px 12px;
      border-radius: 12px;
      border: 1px solid var(--border);
      background: #fff;
      box-shadow: 0 10px 22px rgba(0,0,0,.05);
      font-size: 13.5px;
    }
    .details-ratting-wrapper i{ color: #FFDF00; font-size: 14px; }
    .details-ratting-wrapper i.far.fa-star{ color: #959595; }
    .all-reviews-button{
      text-decoration: none;
      margin-left: 6px;
      cursor:pointer;
      font-weight: 900;
      color: var(--brand-dark);
      position: relative;
      white-space: nowrap;
    }
    .all-reviews-button:after{
      content:"";
      position:absolute;
      left:0; right:0; bottom:-3px;
      height:2px;
      background: var(--brand-gradient);
      border-radius: 999px;
      transform: scaleX(.65);
      transform-origin:left;
      transition: transform var(--t);
    }
    .all-reviews-button:hover:after{ transform: scaleX(1); }

    .product-code p{
      display: inline-flex;
      align-items:center;
      gap: 8px;
      background: linear-gradient(90deg, rgba(60,125,23,1), rgba(34,197,94,.95));
      color:#fff;
      padding: 9px 12px;
      border-radius: 12px;
      line-height: 1;
      margin: 0 0 10px;
      font-weight: 800;
      box-shadow: 0 12px 26px rgba(34,197,94,.15);
      border: 1px solid rgba(255,255,255,.25);
      font-size: 14px;
    }

    .hide_span{ display:none; }
    .size{ cursor:pointer; user-select:none; transition: all var(--t); }

    #variantBox{ margin-top: 10px !important; }
    #variantBox label{ font-size: 13px; margin-bottom: 6px !important; font-weight: 700; }

    #variantBox .size{
      background: #fff;
      border: 1px solid var(--border) !important;
      border-radius: 999px !important;
      padding: 9px 14px !important;
      font-weight: 900;
      color: var(--text);
      box-shadow: 0 8px 18px rgba(0,0,0,.05);
      font-size: 14px;
    }
    #variantBox .size:hover{
      transform: translateY(-1px);
      box-shadow: 0 14px 28px rgba(0,0,0,.08);
      border-color: rgba(0,39,108,.18) !important;
    }
    #variantBox .size.active{
      border-color: rgba(29,95,171,1) !important;
      background: var(--brand-gradient) !important;
      color: var(--brand-text) !important;
      box-shadow: 0 18px 40px rgba(0,39,108,.14);
    }

    .size_name{
      margin-top: 8px;
      display:inline-block;
      padding: 6px 12px;
      border-radius: 999px;
      background: rgba(22,163,74,.10);
      border: 1px solid rgba(22,163,74,.18);
      color: rgba(22,101,52,1) !important;
      font-weight: 900;
      font-size: 13.5px;
    }

    .qty-cart{
      width: auto;
      display: flex;
      align-items: center;
      column-gap: 12px;
      margin-top: 8px;
    }
    .qty-cart .quantity{
      position: relative;
      border: 1px solid rgba(2,6,23,.18);
      height: 44px;
      overflow: hidden;
      width: 148px;
      margin-top: 0;
      border-radius: 999px;
      background: #fff;
      box-shadow: 0 10px 22px rgba(0,0,0,.06);
    }
    .quantity .minus,
    .quantity .plus{
      position: absolute;
      bottom: 0;
      z-index: 2;
      height: 44px;
      line-height: 44px;
      width: 44px;
      text-align: center;
      cursor: pointer;
      transition: all var(--t);
      user-select:none;
      font-weight: 900;
      color: var(--brand-dark);
      background: rgba(0,39,108,.04);
    }
    .quantity .minus{
      left:0;
      border-right: 1px solid rgba(2,6,23,.10);
      font-size: 28px;
    }
    .quantity .plus{
      right:0;
      border-left: 1px solid rgba(2,6,23,.10);
      font-size: 20px;
    }
    .quantity .minus:hover,
    .quantity .plus:hover{ background: rgba(0,39,108,.08); }
    .quantity input{
      position: relative;
      z-index: 1;
      text-align: center;
      font-size: 15px;
      height: 100%;
      width: 100%;
      font-weight: 900;
      color: var(--text);
      background: #fff !important;
      border: none !important;
      outline: none !important;
      pointer-events: none;
    }

    .single_product{
      gap: 10px;
      margin-top: 10px !important;
      display:flex;
    }

    .add_cart_btn,
    .order_now_btn{
      height: 48px !important;
      border-radius: 14px !important;
      font-weight: 900 !important;
      letter-spacing: .2px;
      display:flex;
      align-items:center;
      justify-content:center;
      gap: 8px;
      transition: all var(--t);
      box-shadow: 0 14px 30px rgba(0,0,0,.10);
      border: 1px solid rgba(2,6,23,.10) !important;
      font-size: 15px;
      width: 50%;
    }
    .add_cart_btn{
      color: #fff !important;
      background: linear-gradient(90deg, rgba(34,197,94,1), rgba(16,185,129,1)) !important;
    }
    .add_cart_btn:hover{
      transform: translateY(-1px);
      box-shadow: 0 20px 44px rgba(16,185,129,.18);
      filter: brightness(1.02);
    }
    
    /* ========================================= */
    /* 🔥 UPDATED ORDER NOW BUTTON ANIMATION 🔥 */
    /* ========================================= */
    
    /* 1. Gradient Movement Animation */
    @keyframes gradientShake {
        0% { background-position: 0% 50%; }
        50% { background-position: 100% 50%; }
        100% { background-position: 0% 50%; }
    }

    /* 2. Pulse / Heartbeat Glow Animation */
    @keyframes glowingPulse {
        0% { 
            box-shadow: 0 0 0 0 rgba(13, 110, 253, 0.7); 
            transform: scale(1); 
        }
        50% { 
            box-shadow: 0 0 0 12px rgba(13, 110, 253, 0); 
            transform: scale(1.03); 
        }
        100% { 
            box-shadow: 0 0 0 0 rgba(13, 110, 253, 0); 
            transform: scale(1); 
        }
    }

    .order_now_btn{
      /* Use a rich gradient mixing brand colors for animation depth */
      background: linear-gradient(45deg, #00276C, #2563eb, #00276C, #3b82f6) !important;
      background-size: 300% 300% !important;
      color: #fff !important;
      margin-left: 0 !important;
      position: relative;
      z-index: 1;
      border: none !important;
      /* Applying the Animations */
      animation: gradientShake 3s ease infinite, glowingPulse 2s infinite !important;
    }

    /* Hover State override */
    .order_now_btn:hover{
      filter: brightness(1.1);
      /* Pause animation or enhance it on hover if preferred */
    }

    /* ========================================= */
    /* END ANIMATION */
    /* ========================================= */

    .cta-stack{
      margin-top: 12px;
      display: grid;
      grid-template-columns: 1fr 1fr;
      gap: 10px;
    }
    .cta-stack .shadow{
      border-radius: 14px;
      overflow:hidden;
      box-shadow: none !important;
    }
    .cta-stack .btn{
      font-size: 15px !important;
      padding: 12px 14px !important;
      border-radius: 14px !important;
      font-weight: 900 !important;
      line-height: 1.2;
    }

    a.btn.main-bg{
      box-shadow: var(--shadow) !important;
      border: 1px solid rgba(255,255,255,.18) !important;
      transition: all var(--t);
    }
    a.btn.main-bg:hover{
      transform: translateY(-1px);
      box-shadow: var(--shadowHover) !important;
    }
    .btn-success{
      box-shadow: 0 16px 40px rgba(34,197,94,.14) !important;
      border: 1px solid rgba(255,255,255,.20) !important;
      transition: all var(--t);
    }
    .btn-success:hover{
      transform: translateY(-1px);
      box-shadow: 0 22px 54px rgba(34,197,94,.18) !important;
    }

    .courier-card{
      margin-top: 14px;
      background: #fff;
      border: 1px solid var(--border);
      border-radius: 16px;
      overflow: hidden;
      box-shadow: 0 12px 28px rgba(0,0,0,.08);
    }
    .courier-card .courier-title{
      background: rgba(0,39,108,.06);
      font-weight: 900;
      padding: 11px 14px;
      text-align:center;
      border-bottom: 1px solid rgba(2,6,23,.08);
      font-size: 15px;
    }
    .courier-card table{ margin:0; border: none !important; }
    .courier-card table td{
      padding: 10px 14px !important;
      border-color: rgba(2,6,23,.10) !important;
      font-weight: 700;
      color: var(--text);
      font-size: 14px;
    }
    .courier-card table td:last-child{ font-weight: 900; text-align:right; }

    .product-metas{
      margin-top: 10px !important;
      font-size: 14px;
      line-height: 1.45;
    }
    .product-metas li{ margin-bottom: 4px; }

    @media (max-width: 575.98px){
      .cta-stack{ grid-template-columns: 1fr; }
      .details_right{ padding: 14px; }
      .product-cart .name{ font-size: 18px; }
    }

    .nav.nav-tabs{
      border: 1px solid rgba(0,39,108,.16);
      border-radius: 14px;
      background: #fff;
      padding: 8px;
      box-shadow: 0 12px 26px rgba(0,0,0,.06);
      gap: 10px !important;
    }
    .nav.nav-tabs .nav-item a{
      margin: 0;
      padding: 12px 18px;
      font-weight: 900;
      color: var(--text);
      border-radius: 12px;
      border: 1px solid transparent;
      transition: all var(--t);
    }
    .nav.nav-tabs .nav-item a:hover{
      background: rgba(0,39,108,.05);
      border-color: rgba(0,39,108,.10);
    }
    .nav-tabs .nav-link.active{
      color: var(--brand-text) !important;
      background: var(--brand-gradient) !important;
      border-color: rgba(29, 95, 171, 1) !important;
      box-shadow: 0 18px 44px rgba(0,39,108,.14);
    }

    .single-desc,
    .single-desc * ,
    .product-desc-wrapper,
    .product-desc-wrapper * ,
    .woocommerce-tabs .tab-content,
    .woocommerce-tabs .tab-content * {
      font-family: 'Hind Siliguri', sans-serif !important;
    }

    /* ------- FORCE ICON FIX: Overriding the Hind Siliguri ------- */
    /* This specifically fixes the [] box and missing icons */
    .woocommerce-tabs .tab-content i,
    .woocommerce-tabs .tab-content .fa,
    .woocommerce-tabs .tab-content .fas,
    .woocommerce-tabs .tab-content .far,
    .woocommerce-tabs .tab-content .fab,
    .rating-component .stars-box i,
    .details-ratting-wrapper i,
    .compliment-container i {
      font-family: "Font Awesome 5 Free" !important;
      font-style: normal !important;
      display: inline-block !important;
      visibility: visible !important;
      opacity: 1 !important;
      font-weight: 900;
      line-height: 1 !important;
      text-transform: none !important;
    }
    /* Brand icons need specific weight */
    .woocommerce-tabs .tab-content .fab {
        font-family: "Font Awesome 5 Brands" !important;
        font-weight: 400 !important;
    }

    /* ------- PREMIUM COMPACT REVIEW FORM STYLES ------- */
    .premium-review-card {
        background: #fff;
        border: 1px solid rgba(0,39,108,0.08);
        border-radius: 16px;
        padding: 20px; /* Reduced padding from 24px */
        box-shadow: 0 10px 30px rgba(0,0,0,0.06);
        position: relative;
        overflow: hidden;
    }
    /* Subtle decorative background */
    .premium-review-card::before {
        content: '';
        position: absolute;
        top: -50px; left: -50px;
        width: 100px; height: 100px;
        background: var(--brand-gradient);
        opacity: 0.05;
        border-radius: 50%;
    }

    .review-header-title {
        font-weight: 800;
        font-size: 16px; /* Reduced font size */
        color: var(--brand-dark);
        margin-bottom: 15px; /* Reduced margin */
        position: relative;
        display: inline-block;
    }
    
    /* Center Rating Box - Made more compact */
    .rating-box-wrapper {
        text-align: center;
        background: #f8fbff;
        border-radius: 10px;
        padding: 10px; /* Reduced padding */
        border: 1px solid rgba(0,39,108,0.06);
        margin-bottom: 15px; /* Reduced margin */
    }

    .rating-label {
        display: block;
        font-weight: 700;
        font-size: 13px; /* Reduced size */
        color: var(--muted);
        margin-bottom: 6px;
    }
    
    /* Star Styling */
    .rating-component .stars-box {
        display: flex;
        justify-content: center;
        gap: 8px; /* Reduced gap */
    }
    
    .rating-component .stars-box .star {
        font-size: 20px; /* Reduced size from 26px */
        color: #e2e8f0;
        cursor: pointer;
        transition: all 0.2s cubic-bezier(0.175, 0.885, 0.32, 1.275);
    }
    
    .rating-component .stars-box .star.hover,
    .rating-component .stars-box .star.selected {
        color: #fbbf24;
        filter: drop-shadow(0 2px 4px rgba(251, 191, 36, 0.2));
        transform: scale(1.15);
    }

    /* Feedback Tags & Compliment */
    .tags-container {
        display: none;
        margin-top: 10px;
        animation: slideUpFade 0.4s ease forwards;
    }
    
    .question-tag {
        background: rgba(239, 68, 68, 0.08); /* Light Red for bad */
        color: #b91c1c;
        font-weight: 700;
        padding: 4px 12px;
        border-radius: 999px;
        font-size: 12px;
        display: inline-block;
    }
    
    .tags-container[data-tag-set="4"] .question-tag {
        background: rgba(34, 197, 94, 0.1); /* Green for good */
        color: var(--success);
    }

    .make-compliment {
        text-align: center;
    }
    .compliment-container {
        display: inline-flex;
        align-items: center;
        gap: 6px;
        background: linear-gradient(135deg, rgba(34, 197, 94, 0.1), rgba(34, 197, 94, 0.2));
        color: #15803d;
        padding: 6px 16px; /* Compact padding */
        border-radius: 999px;
        font-weight: 800;
        font-size: 13px;
        border: 1px solid rgba(34, 197, 94, 0.15);
        box-shadow: 0 4px 12px rgba(34, 197, 94, 0.1);
    }
    /* Bounce Animation for Icon */
    .compliment-container i {
        font-size: 16px;
        animation: bounceIcon 2s infinite;
        color: #15803d !important; /* Ensure visibility */
    }

    /* Modern Inputs - Compact */
    .premium-input-group label {
        font-weight: 700;
        font-size: 11px; /* Smaller label */
        text-transform: uppercase;
        color: var(--muted);
        margin-bottom: 4px;
        letter-spacing: 0.5px;
        display: block;
    }
    
    .premium-input-group input,
    .premium-input-group textarea,
    .premium-input-group .form-control {
        background: #fdfdfd;
        border: 1px solid #e2e8f0;
        border-radius: 8px; /* Slightly tighter radius */
        padding: 8px 12px; /* Reduced Padding */
        width: 100%;
        font-weight: 600;
        font-size: 13px; /* Smaller font */
        color: var(--text);
        transition: all 0.3s ease;
    }
    
    /* File Input Specific */
    .premium-input-group input[type="file"] {
        padding: 6px 12px;
        font-size: 11px;
        background: #f8fafc;
    }

    .premium-input-group input:focus,
    .premium-input-group textarea:focus {
        background: #fff;
        border-color: var(--brand-dark);
        box-shadow: 0 0 0 4px rgba(0,39,108,0.05);
        outline: none;
    }

    /* Animations */
    @keyframes slideUpFade {
        from { opacity: 0; transform: translateY(10px); }
        to { opacity: 1; transform: translateY(0); }
    }
    @keyframes bounceIcon {
        0%, 20%, 50%, 80%, 100% {transform: translateY(0);}
        40% {transform: translateY(-4px);}
        60% {transform: translateY(-2px);}
    }

    @media(max-width: 575px){
        .nav.nav-tabs .nav-item a{ padding: 8px 10px; font-size: 12px; border-radius: 10px; }
        .mx_0{ margin-left: -5px; margin-right: -5px; }
        .details_right{ padding: 12px; border-radius: 16px; }
        .product-cart .name{ font-size: 18px; }
        .details-price{ font-size: 22px; }
        .add_cart_btn, .order_now_btn{ height: 46px !important; border-radius: 14px !important; }
        .qty-cart .quantity{ width: 140px; }
        .premium-review-card { padding: 15px; }
        .rating-component .stars-box .star { font-size: 22px; }
    }

    button:disabled,
    .btn:disabled{
      opacity: .55 !important;
      cursor: not-allowed !important;
      box-shadow: none !important;
      transform: none !important;
      filter: grayscale(12%);
    }
</style>
@endpush

@section('content')
<main class="main-wrapper">
    <div class="axil-single-product-area p pb--0 bg-color-white">
        <div class="single-product-thumb mb--5">
            <div class="container-fluid p-lg-5 mobile_show">
                <div class="row">
                    <div class="col-lg-6 mb--10">
                        <div class="row mx_0">
                            <div class="col-lg-10 order-lg-2">
                                <div class="single-product-thumbnail-wrap zoom-gallery overflow-hidden">
                                    <div class="single-product-thumbnail product-large-thumbnail-3 img-section axil-product">
                                        <div class="thumbnail h-100 overflow-hidden">
                                            <a href="{{ getImage('products', $singleProduct->image)}}" class="popup-zoom">
                                                <img src="{{ getImage('products', $singleProduct->image)}}" alt="{{ $singleProduct->name}} Images">
                                            </a>
                                        </div>
                                        @foreach($singleProduct->images as $im)
                                        <div class="thumbnail h-100 overflow-hidden">
                                            <a href="{{ getImage('products', $im->image)}}" class="popup-zoom">
                                                <img src="{{ getImage('products', $im->image)}}" alt="{{ $singleProduct->name}} Images">
                                            </a>
                                        </div>
                                        @endforeach
                                    </div>

                                    @if($singleProduct->after_discount > 0)
                                        @php
                                            $price = $singleProduct->sell_price;
                                            $afterDiscount = $singleProduct->after_discount;
                                            $discountAmount = $price - $afterDiscount;
                                            $discountPercent = $price > 0 ? round(($discountAmount / $price) * 100, 0) : 0;
                                        @endphp
                                        <div class="label-block">
                                            <div class="product-badget" style="background: #00276C;">
                                                {{$discountPercent}} % Off
                                            </div>
                                        </div>
                                    @endif

                                    <div class="product-quick-view position-view">
                                        <a href="{{ getImage('products', $singleProduct->image)}}" class="popup-zoom">
                                            <i class="far fa-search-plus"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-2 order-lg-1 px-lg-0">
                                <div class="product-small-thumb-3 small-thumb-wrapper">
                                    <div class="small-thumb-img mt-2">
                                        <img src="{{ getImage('products', $singleProduct->image)}}" alt="{{ $singleProduct->name}} image">
                                    </div>
                                    @foreach($singleProduct->images as $im)
                                    <div class="small-thumb-img mt-2">
                                        <img src="{{ getImage('products', $im->image)}}" alt="{{ $singleProduct->name}} image">
                                    </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-sm-6 mb--30">
                        <div class="details_right">
                            <div class="product">
                                <div class="product-cart">
                                    <p class="name">{{ $singleProduct->name}}</p>

                                    <p class="details-price">
                                        @if($initRaw > $initFinal && $initRaw > 0)
                                          <del id="product-old-price" class="price old-price">
                                            @if($curr == 'BDT')
                                                ৳ {{ (int)$initRaw }}
                                            @elseif ($curr == 'Dollar')
                                                $ {{ $initRaw }}
                                            @elseif ($curr == 'Euro')
                                                € {{ $initRaw }}
                                            @elseif ($curr == 'Rupee')
                                                 {{ $initRaw }}
                                            @endif
                                          </del>
                                        @else
                                          <del id="product-old-price" class="price old-price" style="display:none;"></del>
                                        @endif

                                        @if($curr == 'BDT')
                                          <span class="current-price-product">৳ {{ (int)$initFinal }}</span>
                                        @elseif ($curr == 'Dollar')
                                          <span class="current-price-product">$ {{ $initFinal }}</span>
                                        @elseif ($curr == 'Euro')
                                          <span class="current-price-product">€ {{ $initFinal }}</span>
                                        @elseif ($curr == 'Rupee')
                                          <span class="current-price-product">{{ $initFinal }}</span>
                                        @endif
                                    </p>

                                    <div class="mb-2">
                                        <span class="badge bg-{{ $inStock ? 'success' : 'danger' }} text-light">
                                            {{ $inStock ? (int)$initialStock : '0' }} Items left
                                        </span>
                                    </div>

                                    <div class="details-ratting-wrapper">
                                        @php
                                            $totalReviews = $singleProduct->reviews->count();
                                            $averageRating = $totalReviews > 0 ? round($singleProduct->reviews->avg('review'), 2) : 0;
                                        @endphp
                                        <span>{{ $totalReviews }} Reviews</span>
                                        @for ($i = 1; $i <= 5; $i++)
                                            @if ($i <= $averageRating)
                                                <i class="fas fa-star text-warning"></i>
                                            @elseif ($i - 0.5 <= $averageRating)
                                                <i class="fas fa-star-half-alt text-warning"></i>
                                            @else
                                                <i class="far fa-star text-warning"></i>
                                            @endif
                                        @endfor
                                        <span>{{ number_format($averageRating, 2) }}/5</span>
                                        <a class="all-reviews-button" href="#writeReview">See Reviews</a>
                                    </div>

                                    @php
                                        $singleProductName = $singleProduct->name;
                                        $sku = $singleProduct->sku;
                                        $singleProductUrl = url("/product-show/{$singleProduct->id}");
                                        $message = "Hello, I am interested in your product: {$singleProductName} - ({$sku}). Here is the link: {$singleProductUrl}";
                                        $encodedMessage = urlencode($message);
                                        $whatsappNumber = preg_replace('/[^0-9]/', '', $info->whats_num ?? '');
                                    @endphp

                                    <div class="product-code">
                                        <p><span>{{ $dt->product_code_text ?? 'প্রোডাক্ট কোড :' }} </span>{{ $singleProduct->sku }}</p>
                                    </div>

                                    @if(isset($singleProduct->variations) && $singleProduct->variations->count() > 0 && (count($sizesMap) || count($colorsMap)))
                                      <div class="mt-3" id="variantBox">

                                        @if($showSize)
                                          <label class="mb-2" style="font-weight:600;">Size:</label>
                                          <div class="d-flex flex-wrap gap-2" id="sizeOptions">
                                            @foreach($sizesMap as $sid => $slabel)
                                              <div class="size size-opt {{ ((int)$sid === (int)$defaultSizeId) ? 'active' : '' }}"
                                                   data-size-id="{{ (int)$sid }}">
                                                {{ $slabel }}
                                              </div>
                                            @endforeach
                                          </div>
                                        @endif

                                        @if($showColor)
                                          <label class="mb-2 mt-3" style="font-weight:600;">Color:</label>
                                          <div class="d-flex flex-wrap gap-2" id="colorOptions">
                                            @foreach($colorsMap as $cid => $clabel)
                                              <div class="size color-opt {{ ((int)$cid === (int)$defaultColorId) ? 'active' : '' }}"
                                                   data-color-id="{{ (int)$cid }}">
                                                {{ $clabel }}
                                              </div>
                                            @endforeach
                                          </div>
                                        @endif

                                        <span class="size_name mt-2 d-block text-success fw-bold"></span>

                                        <script>
                                          window.__VAR_MAP__ = @json($varMap);
                                          window.__VAR_DEFAULT__ = {
                                            size_id: {{ (int)$defaultSizeId }},
                                            color_id: {{ (int)$defaultColorId }},
                                            default_size_id: {{ (int)$DEFAULT_SIZE_ID }},
                                            default_color_id: {{ (int)$DEFAULT_COLOR_ID }},
                                            show_size: {{ $showSize ? 'true' : 'false' }},
                                            show_color: {{ $showColor ? 'true' : 'false' }},
                                          };
                                        </script>
                                      </div>
                                    @else
                                      <script>
                                        window.__VAR_MAP__ = @json($varMap);
                                        window.__VAR_DEFAULT__ = {
                                          size_id: {{ (int)$defaultSizeId }},
                                          color_id: {{ (int)$defaultColorId }},
                                          default_size_id: {{ (int)$DEFAULT_SIZE_ID }},
                                          default_color_id: {{ (int)$DEFAULT_COLOR_ID }},
                                          show_size: false,
                                          show_color: false,
                                        };
                                      </script>
                                    @endif

                                    <form action="{{ route('front.carts.storeCart') }}" id="cart_submit" method="POST">
                                        @csrf
                                        <input type="hidden" name="product_id" value="{{ $singleProduct->id }}">
                                        <input type="hidden" name="product_name" value="{{ $singleProduct->name }}">
                                        <input type="hidden" name="category_id" value="{{ $singleProduct->category->name??'' }}">

                                        {{-- 1. Selection: JS updates these hidden inputs --}}
                                        <input type="hidden" name="variation_id" id="variation_id" value="{{ $initialVar['id'] ?? '' }}">
                                        <input type="hidden" name="variant_name" id="variant_name" value="">

                                        <input type="hidden" id="size_value"  name="size_value"  value="">
                                        <input type="hidden" id="size_value1" name="size_value1" value="">
                                        <input type="hidden" id="price_val"   name="price_val"   value="{{ $initialVar['price'] ?? ($singleProduct->after_discount > 0 ? $singleProduct->after_discount : $singleProduct->sell_price) }}">
                                        <input type="hidden" id="price_val1"  name="price_val1"  value="{{ $initialVar['price'] ?? ($singleProduct->after_discount > 0 ? $singleProduct->after_discount : $singleProduct->sell_price) }}">

                                        {{-- 4. Set Action: Hidden input for action_type (Cart/Order) --}}
                                        <input type="hidden" name="action_type" id="input_action_type" value="cart">

                                        <div class="mt-3">
                                            <div class="qty-cart col-sm-12">
                                                <div class="quantity">
                                                    <span class="minus">-</span>
                                                    {{-- ✅✅ FIXED: MIN=1 and READONLY --}}
                                                    <input type="number" name="quantity" value="1" min="1" readonly>
                                                    <span class="plus">+</span>
                                                </div>
                                            </div>

                                            <div class="d-flex single_product col-sm-12">
                                                {{-- 2. Click: Add To Cart Button --}}
                                                <button type="submit"
                                                        class="btn px-4 add_cart_btn animated_text"
                                                        style="font-family: 'Hind Siliguri', sans-serif"
                                                        {{ $inStock ? '' : 'disabled' }}>
                                                    {{ $dt->add_to_cart_text ?? 'কার্টে যোগ করুন' }}
                                                </button>

                                                <button type="submit"
                                                        class="btn px-4 order_now_btn animated_text order_now_btn_m main-bg"
                                                        style="font-family: 'Hind Siliguri', sans-serif"
                                                        {{ $inStock ? '' : 'disabled' }}>
                                                    {{ $dt->order_now_text ?? 'অর্ডার করুন' }}
                                                </button>
                                            </div>
                                        </div>

                                        <div class="cta-stack">
                                            <div class="shadow">
                                                <a href="tel:{{$info->supp_num1}}" class="btn btn-primary main-bg d-block py-3 fs-3 text-light fw-bolder" style="font-family: 'Hind Siliguri', sans-serif;">
                                                    কল করুন <i class="fas fa-phone-volume"></i> {{$info->supp_num1}}
                                                </a>
                                            </div>
                                            <div class="shadow">
                                                <a href="https://wa.me/+88{{ $whatsappNumber }}?text={{ $encodedMessage }}" target="_blank" class="btn btn-success py-3 d-block fs-3 text-light fw-bolder">
                                                    Whatsapp <img width="20px" height="20px" src="https://img.icons8.com/color/48/whatsapp--v1.png" alt="whatsapp--v1"> {{$info->whats_num}}
                                                </a>
                                            </div>
                                        </div>

                                        <div class="courier-card" style="font-family: 'Hind Siliguri', sans-serif;">
                                            <div class="courier-title">{{ $dt->courier_delivery_cost_text ?? 'কুরিয়ার ডেলিভারি খরচ' }}</div>
                                            <table class="table table-bordered border-0">
                                                <tbody>
                                                    @foreach($charges as $charge)
                                                    <tr>
                                                        <td>{{ $charge->title }}</td>
                                                        <td>৳ {{ number_format($charge->amount, 0) }}</td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>

                                        <ul class="product-metas mt-3" style="font-family: 'Hind Siliguri', sans-serif;">
                                          {!! $singleProduct->feature !!}
                                        </ul>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="woocommerce-tabs wc-tabs-wrapper">
        <div class="container-fluid">
        <ul class="nav nav-tabs mb-4 gap-3" id="myTab" role="tablist">
          <li class="nav-item" role="presentation">
            <a class="nav-link active" id="home-tab" data-bs-toggle="tab" href="#home" role="tab" aria-controls="home" aria-selected="true">Details</a>
          </li>
          <li class="nav-item" role="presentation">
            <a class="nav-link" id="review-tab" data-bs-toggle="tab" href="#review" role="tab" aria-controls="review" aria-selected="false">Reviews</a>
          </li>
        </ul>
        <div class="tab-content" id="myTabContent">
          <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
              <div class="product-desc-wrapper">
                <div class="">
                    <div class="col-lg-12 mb--20">
                        <h5 class="title">{{ $dt->short_description_text ?? 'Description' }}</h5>
                        <div class="single-desc pt-4">
                            @if($singleProduct->video_link)
                            <div class="col-lg-5">
                              {!! $singleProduct->video_link !!}
                            </div>
                            @endif
                            {!! $singleProduct->body !!}
                        </div>
                    </div>
                </div>
            </div>
          </div>

          <div class="tab-pane fade" id="review" role="tabpanel" aria-labelledby="review-tab">
            <div class="woocommerce-tabs wc-tabs-wrapper" id="writeReview" style="background: #f7fffb;">
                <div class="container">
                    <div class="reviews-wrapper pt-4">
                        <div class="row">
                            <div class="col-lg-6 mb--20">
                                <div class="axil-comment-area pro-desc-commnet-area pt-3">
                                    <h5 class="title">({{$singleProduct->reviews->count()}}) Relative Product</h5>
                                    <ul class="comment-list">
                                        @include("frontend.products.partials.reviewList")
                                    </ul>
                                </div>
                            </div>

                            <div class="col-lg-6 mb--20">
                                <div class="premium-review-card">
                                    <div class="comment-respond pro-des-commend-respond mt--0">
                                        <h5 class="review-header-title">Add a Review</h5>
                                        
                                        <form action="{{ route('front.product-reviews.store')}}" method="POST" id="ajax_form2" enctype="multipart/form-data">
                                            @csrf
                                            <input type="hidden" name="product_id" value="{{$singleProduct->id}}" />
                                            <input type="hidden" name="review" id="review" value="" />
                                            
                                            <div class="rating-box-wrapper">
                                                <span class="rating-label">How was your experience?</span>
                                                <div class="rating-component">
                                                    <div class="status-msg">
                                                        <input class="rating_msg" type="hidden" name="rating_msg" value="" />
                                                    </div>
                                                    <div class="stars-box">
                                                        <i class="star fa fa-star" title="1 star" data-message="Poor" data-value="1"></i>
                                                        <i class="star fa fa-star" title="2 stars" data-message="Too bad" data-value="2"></i>
                                                        <i class="star fa fa-star" title="3 stars" data-message="Average quality" data-value="3"></i>
                                                        <i class="star fa fa-star" title="4 stars" data-message="Nice" data-value="4"></i>
                                                        <i class="star fa fa-star" title="5 stars" data-message="Very good quality" data-value="5"></i>
                                                    </div>
                                                    <div class="starrate">
                                                        <input class="ratevalue" type="hidden" name="rate_value" value="" />
                                                    </div>
                                                </div>

                                                <div class="feedback-tags">
                                                    <div class="tags-container" data-tag-set="1">
                                                        <div class="question-tag">Why was your experience so bad?</div>
                                                    </div>
                                                    <div class="tags-container" data-tag-set="2">
                                                        <div class="question-tag">Why was your experience so bad?</div>
                                                    </div>
                                                    <div class="tags-container" data-tag-set="3">
                                                        <div class="question-tag">Why was your average rating experience?</div>
                                                    </div>
                                                    <div class="tags-container" data-tag-set="4">
                                                        <div class="question-tag">Why was your experience good?</div>
                                                    </div>
                                                    <div class="tags-container" data-tag-set="5">
                                                        <div class="make-compliment">
                                                            <div class="compliment-container">
                                                                <span class="compliment-text">Give a compliment</span>
                                                                <i class="fas fa-smile-wink"></i>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="row">
                                                <div class="col-lg-6 col-md-6 col-12 mb-2">
                                                    <div class="premium-input-group">
                                                        <label>Name <span class="text-danger">*</span></label>
                                                        <input id="name" type="text" name="name" required placeholder="Your Name"/>
                                                    </div>
                                                </div>

                                                <div class="col-lg-6 col-md-6 col-12 mb-2">
                                                    <div class="premium-input-group">
                                                        <label>Image (optional)</label>
                                                        <input type="file" class="form-control" name="image">
                                                    </div>
                                                </div>

                                                <div class="col-12 mb-3">
                                                    <div class="premium-input-group">
                                                        <label>Other Notes (optional)</label>
                                                        <textarea name="message" rows="2" placeholder="Write your feedback here..."></textarea>
                                                    </div>
                                                </div>

                                                <div class="col-lg-12">
                                                    <div class="button-box form-submit">
                                                        <button type="submit" class="btn btn-primary w-100 py-2 fw-bold" style="border-radius:10px; font-size:15px; background: var(--brand-gradient); border:none; box-shadow: 0 8px 20px rgba(0,39,108,0.15);">
                                                            Submit Review <i class="fas fa-paper-plane ms-2"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <style>.row>[class*=col]{ padding-left:5px; padding-right:5px; }</style>

    <div class="axil-product-area bg-color-white pt--10">
        <div class="container-fluid">
            <div class="section-title-wrapper">
                <h2 class="border-bottom border-2" style="font-family: 'Arial', sans-serif;">Related Products</h2>
            </div>
            <div class="explore-product-activation slick-layout-wrapper slick-layout-wrapper--15 axil-slick-arrow arrow-top-slide">
                <div class="slick-single-layout" id="relative_data">
                    <div class="row row--15">
                        @foreach($products as $product)
                        <div class="col-lg-2 col-md-3 col-6 mb--30">
                            @include('frontend.products.partials.product_section')
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>

        </div>
    </div>
</main>
@endsection

@push('js')
<script>
(function(){

  // =============================
  // ✅ GLOBAL GUARDS (Prevent Duplicate Fires)
  // =============================
  window.__PIXEL_GUARD__ = window.__PIXEL_GUARD__ || {
    viewContent: {},  // per product id
    addToCart: {}     // per event id
  };

  // ------------- FAST TOAST CONFIGURATION -------------
  if(window.toastr){
      toastr.options = {
        "closeButton": true,
        "debug": false,
        "newestOnTop": true,
        "progressBar": true,
        "positionClass": "toast-top-right",
        "preventDuplicates": false,
        "onclick": null,
        "showDuration": "200",
        "hideDuration": "300",
        "timeOut": "2000",
        "extendedTimeOut": "1000",
        "showEasing": "swing",
        "hideEasing": "linear",
        "showMethod": "fadeIn",
        "hideMethod": "fadeOut"
      };
  }

  function toastUnique(type, msg){
    if(!window.toastr) return;
    toastr.clear();
    toastr[type](msg);
  }

  // ======================================================
  // ✅ ViewContent Pixel Fire (FIXED: Will fire only ONCE)
  // ======================================================
  $(function(){
    setTimeout(function(){

      let product_id    = {{ $singleProduct->id }};
      let product_name = {!! json_encode($singleProduct->name) !!};
      let categoryName = {!! json_encode($singleProduct->category->name ?? '') !!};
      let sell_price    = {{ (isset($singleProduct->after_discount) && $singleProduct->after_discount > 0) ? $singleProduct->after_discount : $singleProduct->sell_price }};

      // ✅ Guard key per product id
      const vcKey = "p_" + product_id;
      if (window.__PIXEL_GUARD__.viewContent[vcKey]) return;
      window.__PIXEL_GUARD__.viewContent[vcKey] = true;

      // ✅ Unique event id (per page load)
      const eventID = "SV_" + product_id + "_" + Date.now();

      if (typeof fbq === 'function') {
        fbq('track', 'ViewContent', {
          content_ids: [product_id],
          content_name: product_name,
          content_type: "product",
          value: sell_price,
          currency: "BDT",
          contents: [{ id: product_id, quantity: 1, item_price: sell_price }],
          content_category: categoryName
        }, { eventID: eventID });
      }

    }, 500);
  });

  // =============================
  // ✅ See Reviews click → open tab + scroll
  // =============================
  document.addEventListener('DOMContentLoaded', function() {
    document.querySelectorAll('a.all-reviews-button').forEach(function(btn){
      btn.addEventListener('click', function(e){
        e.preventDefault();

        const reviewTabLink = document.querySelector('#review-tab');
        if (reviewTabLink) {
          if (window.bootstrap && bootstrap.Tab) (new bootstrap.Tab(reviewTabLink)).show();
          else reviewTabLink.click();
        }

        setTimeout(function(){
          const target = document.querySelector('#writeReview');
          if (target) target.scrollIntoView({ behavior: 'smooth', block: 'start' });
        }, 250);
      });
    });
  });

  // =============================
  // ✅ Quantity +/- bind once
  // =============================
  document.addEventListener('DOMContentLoaded', function() {
    const qtyWrap = document.querySelector('.quantity');
    if(qtyWrap && !qtyWrap.dataset.bound){
      qtyWrap.dataset.bound = "1";

      const minus = qtyWrap.querySelector('.minus');
      const plus  = qtyWrap.querySelector('.plus');
      const input = qtyWrap.querySelector('input[name="quantity"]');

      if(plus){
        plus.addEventListener('click', (e) => {
          e.preventDefault();
          e.stopImmediatePropagation();
          let v = parseInt(input.value) || 1;
          input.value = v + 1;
        }, true);
      }
      if(minus){
        minus.addEventListener('click', (e) => {
          e.preventDefault();
          e.stopImmediatePropagation();
          let v = parseInt(input.value) || 1;
          if(v > 1) input.value = v - 1;
        }, true);
      }
    }
  });

  // =============================
  // ✅ AJAX Review Submit
  // =============================
  $(document)
    .off('submit.ajaxreview', 'form#ajax_form2')
    .on('submit.ajaxreview', 'form#ajax_form2', function(e){
      e.preventDefault();

      const reviewVal = $(this).find('input[name="review"]').val();
      if(!reviewVal){
        toastUnique('error', 'The review field is required');
        return false;
      }

      var url             = $(this).attr('action');
      var method          = $(this).attr('method');
      var formData = new FormData(this);

      $.ajax({
        type: method,
        url: url,
        data: formData,
        processData: false,
        contentType: false,
        success: function (res) {
          if (res.status) {
            toastUnique('success', res.msg || 'Success');

            if (res.view) $('.comment-list').empty().append(res.view);

            if(res.url){
              document.location.href = res.url;
              return;
            }

            setTimeout(function(){ window.location.reload(); }, 700);
          } else {
            toastUnique('error', res.msg || 'Failed');
          }
        },
        error: function (response){
          if(response.responseJSON && response.responseJSON.errors){
            let shown = new Set();
            Object.values(response.responseJSON.errors).forEach(function(arr){
              (arr || []).forEach(function(m){
                if(!shown.has(m)){
                  shown.add(m);
                  toastUnique('error', m);
                }
              });
            });
          } else {
            toastUnique('error', 'Something went wrong');
          }
        }
      });

      return false;
    });

  // =============================
  // ✅ 2 & 4. Click & Set Action: Button Listener
  // =============================
  $(document)
    .off('click.cartaction', '.add_cart_btn, .order_now_btn')
    .on('click.cartaction', '.add_cart_btn, .order_now_btn', function(){
      // Check which button is clicked and set hidden input
      if($(this).hasClass('add_cart_btn')) {
          $('#input_action_type').val('cart');
      } else if($(this).hasClass('order_now_btn')) {
          $('#input_action_type').val('order');
      }
    });

  // =============================
  // ✅ Helper to Open Cart Sidebar
  // =============================
  function openCartSidebar(){
      const triggers = ['.cart-dropdown-btn', '.header-action .cart-btn', '.cart-btn', '.header-cart'];
      let opened = false;
      triggers.forEach(sel => {
          if($(sel).length && !opened) { $(sel).click(); opened = true; }
      });
      if(!opened) {
          $('body').addClass('cart-open');
          $('#cart-dropdown, #cart_section, .cart-dropdown-wrap').addClass('open show active');
      }
  }

  // =============================
  // ✅✅✅ 3 & 5. Validation & Submit: Main Cart Handler (FIXED)
  // =============================
  $(document)
    .off('submit.cart', 'form#cart_submit')
    .on('submit.cart', 'form#cart_submit', function(e){
      e.preventDefault();

      let form = $(this);

      // 1. Stock Validation
      if(!window.__ACTIVE_VAR__){
        toastUnique('warning', '❌ এই Size-Color কম্বিনেশনটি নেই, অন্যটি সিলেক্ট করুন');
        return false;
      }
      
      const stock = parseInt((window.__ACTIVE_VAR__ && window.__ACTIVE_VAR__.stock) ? window.__ACTIVE_VAR__.stock : 0);
      if(stock <= 0){
        toastUnique('warning', '❌ এই ভ্যারিয়েশনটি স্টকে নেই');
        return false;
      }

      // ✅ 2. QUANTITY FIX
      let qtyInput = form.find('input[name="quantity"]');
      let currentQty = parseInt(qtyInput.val());

      if(isNaN(currentQty) || currentQty < 1) {
          currentQty = 1;
          qtyInput.val(1); 
      }

      // Prepare Data
      let product_id    = form.find('input[name="product_id"]').val();
      let product_name = form.find('input[name="product_name"]').val();
      let category_id  = form.find('input[name="category_id"]').val();
      let sell_price    = parseFloat($('#price_val').val() || 0);
      let actionType    = $('#input_action_type').val(); 

      // PIXEL TRACKING (AddToCart)
      const eventID = "ATC_" + product_id + "_" + Date.now();
      if (!window.__PIXEL_GUARD__.addToCart[eventID]) {
        window.__PIXEL_GUARD__.addToCart[eventID] = true;
        if (typeof fbq === 'function') {
          fbq('track', 'AddToCart', {
              content_ids: [product_id],
              content_name: product_name,
              content_type: 'product',
              value: sell_price,
              currency: 'BDT',
              quantity: currentQty,
              contents: [{ id: product_id, quantity: currentQty, item_price: sell_price }]
          }, { eventID: eventID });
        }
      }

      // 5. Submit: Send POST request (via AJAX)
      let url    = form.attr('action');
      let method = form.attr('method'); 
      let data   = form.serialize();

      $.ajax({
        url: url,
        method: method,
        data: data,
        success: function (res) {
          if (res.success) {
            toastUnique('success', res.msg || 'Added Successfully');

            // ✅ Sidebar HTML Update
            if (res.view || res.html) {
                const html = res.view || res.html;
                $('#cart_section, #cart-dropdown, .cart-dropdown-wrap').html(html);
            }
            
            // ✅✅ ITEM COUNT UPDATE FIX (Multiple Selectors) ✅✅
            if (typeof res.item !== 'undefined') {
                // আমরা এখানে একাধিক ক্লাস টার্গেট করছি যাতে আপনার হেডার ক্লাস মিস না হয়
                $('.cart-count').text(res.item); 
                $('.cart-item-count').text(res.item);
                $('.pro-count').text(res.item); 
            }

            // Amount Update
            if (res.amount) {
                let amountText = res.amount.toString().includes('৳') || res.amount.toString().includes('$') 
                                 ? res.amount 
                                 : '৳ ' + res.amount;
                $('.cart-amount').text(amountText);
            }

            if (actionType === 'order') {
              document.location.href = res.url ? res.url : "{{ url('/checkout') }}";
              return;
            }
            openCartSidebar();

          } else {
            toastUnique('error', res.msg || 'Failed');
          }
        },
        error: function (response) {
          toastUnique('error', 'Something went wrong');
        }
      });

      return false;
    });

  // =============================
  // ✅ Prevent cart dropdown click propagation
  // =============================
  document.addEventListener('click', function(e){
    const cartSection = document.querySelector('#cart_section');
    if(cartSection && cartSection.contains(e.target)){
      e.stopPropagation();
    }
  }, true);

  // =============================
  // ✅ 1. Selection: Helper to update inputs
  // =============================
  function moneyText(val){
    val = parseFloat(val || 0);
    if (isNaN(val)) val = 0;
    return '৳ ' + Math.round(val);
  }

  function resolveVariation(sizeId, colorId){
    const key = String(sizeId) + '|' + String(colorId);
    return (window.__VAR_MAP__ && window.__VAR_MAP__[key]) ? window.__VAR_MAP__[key] : null;
  }

  function applyVariation(v){
    if(!v) return;
    window.__ACTIVE_VAR__ = v;

    const cfg = window.__VAR_DEFAULT__ || {};
    const showSize  = !!cfg.show_size;
    const showColor = !!cfg.show_color;

    let labelParts = [];
    if(showSize && v.size && v.size !== 'Default') labelParts.push(v.size);
    if(showColor && v.color && v.color !== 'Default') labelParts.push(v.color);

    const label = labelParts.join(' - ');
    $('span.size_name').text(label);

    $('.current-price-product').text(moneyText(v.price));

    if (v.raw > v.price && v.raw > 0) {
      $('#product-old-price').show().text(moneyText(v.raw));
    } else {
      $('#product-old-price').hide();
    }

    // 1. Selection Update: Updating hidden inputs
    $('#variation_id').val(v.id);
    $('#variant_name').val(label);
    $('#size_value').val(label);
    if($('#size_value1').length) $('#size_value1').val(label);
    $('#price_val').val(v.price);
    if($('#price_val1').length) $('#price_val1').val(v.price);

    const stock = parseInt(v.stock || 0);
    const badge = document.querySelector('.badge');
    if(badge){
      badge.classList.remove('bg-success','bg-danger');
      badge.classList.add(stock > 0 ? 'bg-success' : 'bg-danger');
      badge.innerHTML = (stock > 0 ? stock : '0') + ' Items left';
    }

    const disable = stock <= 0;
    $('.add_cart_btn, .order_now_btn').prop('disabled', disable);
  }

  function setInvalidState(){
    window.__ACTIVE_VAR__ = null;
    $('span.size_name').text('(Not available)');
    const badge = document.querySelector('.badge');
    if(badge){
      badge.classList.remove('bg-success','bg-danger');
      badge.classList.add('bg-danger');
      badge.innerHTML = '0 Items left';
    }
    $('.add_cart_btn, .order_now_btn').prop('disabled', true);
    toastUnique('warning', '❌ এই Size-Color কম্বিনেশনটি নেই, অন্যটি সিলেক্ট করুন');
  }

  $(document)
    .off('click.sizepick', '#sizeOptions .size-opt')
    .on('click.sizepick', '#sizeOptions .size-opt', function(){
      $('#sizeOptions .size-opt').removeClass('active');
      $(this).addClass('active');

      const sizeId  = parseInt($(this).data('size-id') || 0);
      const colorId = parseInt($('#colorOptions .color-opt.active').data('color-id') || 0);

      const v = resolveVariation(sizeId, colorId);
      if(v) applyVariation(v);
      else setInvalidState();
    });

  $(document)
    .off('click.colorpick', '#colorOptions .color-opt')
    .on('click.colorpick', '#colorOptions .color-opt', function(){
      $('#colorOptions .color-opt').removeClass('active');
      $(this).addClass('active');

      const colorId = parseInt($(this).data('color-id') || 0);
      const sizeId  = parseInt($('#sizeOptions .size-opt.active').data('size-id') || 0);

      const v = resolveVariation(sizeId, colorId);
      if(v) applyVariation(v);
      else setInvalidState();
    });

  $(function(){
    const cfg = window.__VAR_DEFAULT__ || {};

    let sizeId;
    if(cfg.show_size){
      const $s = $('#sizeOptions .size-opt.active');
      sizeId = parseInt(($s.data('size-id')) || 0);
      if(!sizeId){
        const $first = $('#sizeOptions .size-opt').first();
        if($first.length){
          $first.addClass('active');
          sizeId = parseInt($first.data('size-id') || 0);
        }
      }
    } else {
      sizeId = parseInt(cfg.size_id || cfg.default_size_id || 0);
    }

    let colorId;
    if(cfg.show_color){
      const $c = $('#colorOptions .color-opt.active');
      colorId = parseInt(($c.data('color-id')) || 0);
      if(!colorId){
        const $first = $('#colorOptions .color-opt').first();
        if($first.length){
          $first.addClass('active');
          colorId = parseInt($first.data('color-id') || 0);
        }
      }
    } else {
      colorId = parseInt(cfg.color_id || cfg.default_color_id || 0);
    }

    const v = resolveVariation(sizeId, colorId) || (function(){
      const keys = Object.keys(window.__VAR_MAP__ || {});
      return keys.length ? window.__VAR_MAP__[keys[0]] : null;
    })();

    if(v) applyVariation(v);
    else setInvalidState();
  });

  // =============================
  // ✅ Rating UI
  // =============================
  $(".rating-component .star").off('.rate')
    .on("mouseover.rate", function () {
      var onStar = parseInt($(this).data("value"), 10);
      $(this).parent().children("i.star").each(function (e) {
        if (e < onStar) $(this).addClass("hover");
        else $(this).removeClass("hover");
      });
    })
    .on("mouseout.rate", function () {
      $(this).parent().children("i.star").removeClass("hover");
    });

  $(".rating-component .stars-box .star").off('click.rate').on("click.rate", function () {
    var onStar = parseInt($(this).data("value"), 10);
    var stars  = $(this).parent().children("i.star");
    var ratingMessage = $(this).data("message");

    $("input[name='review']").val(onStar);
    $('.rating-component .starrate .ratevalue').val(onStar);
    $(".status-msg .rating_msg").val(ratingMessage);

    for (let i = 0; i < stars.length; i++) $(stars[i]).removeClass("selected");
    for (let i = 0; i < onStar; i++) $(stars[i]).addClass("selected");

    $("[data-tag-set]").css('display', 'none');
    $("[data-tag-set=" + onStar + "]").css('display', 'block');
  });

})();
</script>
@endpush