@extends('frontend.app')
@section('content')
    
<div class="main-wrapper container-fluid">
  <div class="main-wrapper">
    <link rel="stylesheet" href="frontend/css/protecting_our_brands.css">
    <section>
        <div class="pub-banner p-0">
            <img src="frontend/img/updated/20190626_authenticity_lp_c01_hero.jpg" alt="Banner" class="col-12 d-lg-block d-md-block d-none">
            <img src="frontend/img/updated/mobile_20190626_authenticity_lp_c01_hero.jpg" alt="Banner" class="col-12 d-lg-none d-md-none d-block">
        </div>
        <div class="pub-container" style="background-image: url(frontend/img/updated/20180620_counterfeit_lp_c02_background_na.jpg);">
            <div class="container m-auto text-center">
                <h1 class="pt-5 pb-5 serif text-light"><b>
                    PROTECTING OUR BRANDS
                </b></h1>
                    <h4 class="pb-3 serif text-light">
                        <b>
                            Ralph Lauren is a Company built on authenticity.
                        </b>
                    </h4>
                    <p class="text-light">
                        Since founding the Company in 1967 and opening the first Polo Ralph Lauren store in California in 1971, Mr. Ralph Lauren has built the business into the symbol of timeless American style and an iconic global luxury brand operating in more than 50 countries around the world. His creativity, spirit, and perseverance through all these years are what make Ralph Lauren what it is today: an internationally recognized brand and leader in the design, marketing, and distribution of premium apparel, accessories, home goods, and fragrances. The iconic stature of Ralph Lauren has attracted counterfeiters who seek to deceive consumers into believing their products are authentic.
                    </p>
                    <h4 class="pb-3 pt-4 serif text-light">
                        <b>
                            There is only one Ralph Lauren. 
                        </b>
                    </h4>
                    <div class="pub-container-box">
                      <div class="row pt-4 pb-5 ps-lg-5 ps-md-5 p-3 counterfeiting">
                        <div class="col-lg-8 col-md-12 col-12 counterfeiting-text">
                          <h3 class="serif text-center">The Cost of Counterfeiting</h3>
                          <p class="text-lg-start text-md-start text-center pt-2 pb-0" style="letter-spacing: 1.2px;">
                            The sale of counterfeit products eliminates tens of thousands of jobs held by legitimate businesses, jeopardizes fair wages and workplace safety, and negatively impacts economic growth. Counterfeit products pose a serious health and safety risk since they are produced without regard to laws or regulations meant to protect consumers. Moreover, profits from counterfeit sales are often used to fund large criminal organizations, including drug cartels and terrorist groups.
                          </p>
                        </div>
                        <div class="col-lg-4 col-12 counterfeiting-img text-center">
                          <img src="frontend/img/updated/20180620_counterfeit_lp_m_c02_banner_na_RESLICE.png" alt="Counterfeit">
                        </div>
                      </div>
                    </div>

                    <h3 class="text-light text-center serif mt-5">
                      Protecting Our Brands</h3>
                      <p class="text-justify text-light mb-5" style="text-align: justify; text-align-last: center;">
                        Ralph Lauren is deeply committed to the protection of our brands and consumers against counterfeits. We have a dedicated team of brand protection specialists that continually police counterfeiters all over the world. Our brand protection team partners with customs offices, investigators, law enforcement agencies, and law firms globally to shut down counterfeiting operations and remove counterfeit products from the market. Additionally, Ralph Lauren is a member of key organizations dedicated to brand protection, including the International Trademark Association, International AntiCounterfeiting Coalition, and American Apparel & Footwear Association.
                      </p>
                      <div class="row pb-lg-5 pb-md-5 p-3 ps-lg-5 pe-lg-5">
                        <div class="col-lg-4 col-md-12 col-12 text-center m-auto p-3">
                          <img src="frontend/img/updated/20180620_counterfeit_lp_aafa_member_logo_na.png" alt="logo" height="100">
                        </div>
                        <div class="col-lg-4 col-md-12 col-12 text-center m-auto p-3">
                          <img src="frontend/img/updated/20180620_counterfeit_lp_inta_logo_na.png" alt="logo" height="100">
                        </div>
                        <div class="col-lg-4 col-md-12 col-12 text-center m-auto p-3">
                          <img src="frontend/img/updated/20180620_counterfeit_lp_lacc_logo_na.png" alt="logo" width="200">
                        </div>
                      </div>
            </div>

        </div>
    </section>
    <section class="mt-5">
      <div class="pub-container pb-5" style="background-image: url(frontend/img/updated/20180620_counterfeit_lp_c03_banner_na.jpg);">
        <div class="container">
          <h3 class="text-center text-light serif pt-5 p-lg-5 p-md-5 p-4 pb-lg-2 pb-md-2">
            Be Sure You Are Purchasing Authentic Ralph Lauren Products
          </h3>
          <p class="text-light pt-3" style="text-align: justify; text-align-last: center;">
            We believe our consumers deserve to know what they are buying and deserve to enjoy the authentic Ralph Lauren products that convey the true American spirit and experience.
          </p>
          <p class="text-light" style="text-align: justify; text-align-last: center;">
            The only way to ensure you are purchasing new and authentic Ralph Lauren products is to purchase from our authorized retailers. Authentic Ralph Lauren products can be purchased directly from Ralph Lauren–branded stores (<a href="#" class="text-light">click here</a> to find a store near you), RalphLauren.com, and select third-party retailers.
          </p>
          <p class="text-light" style="text-align: justify; text-align-last: center;">
            Ralph Lauren does not sell products through other sources such as individuals, internet auctions, or flea markets. Products offered by these sources as Ralph Lauren may be counterfeit or stolen property. 
          </p>
          <p class="text-light" style="text-align: justify; text-align-last: center;">
            <i>
              Please note that Ralph Lauren does not authenticate products obtained from third parties.
            </i> 
          </p>
        </div>
      </div>
    </section>
    <section class="qr-code">
      <div class="row" style="background: rgb(238, 238, 238);">
        <div class="col-lg-8 col-md-8 col-12 m-auto text-center">
          <div class="container ps-lg-5 p-3 pb-5">
            <h2 class="serif pb-3">
              NEW QR CODES
            </h2>
            <p class="text-center">
                Introducing digital product IDs—our latest initiative in authenticity. These digital tags allow you to authenticate Ralph Lauren products with your smartphone by opening your camera and scanning the QR code next to the product label. Digital product IDs are being phased into Ralph Lauren products, starting with the Polo brand, to ensure you feel secure about the purchase you are making.
            </p>
          </div>
        </div>
        <div class="col-lg-4 col-md-4 col-12 m-auto text-lg-end text-center">
          <img src="frontend/img/updated/20190626_authenticity_lp_c04_banner.jpg" alt="">
        </div>
      </div>
    </section>
    <section>
      <div class="container">
        <div class="row col-lg-10 col-md-12 col-12 m-auto">
          <div class="col-lg-4 col-md-12 col-12 text-center m-auto">
            <img src="frontend/img/updated/20180620_counterfeit_lp_trailgreen_logo_na.png" alt="20180620_counterfeit_lp_trailgreen_logo_na.png" style="margin-top: -5rem;">
          </div>
          <div class="col-lg-8 col-md-12 col-12 text-center m-auto">
            If you have information about counterfeit Ralph Lauren merchandise, please contact us via email at RL-Counterfeits@ralphlauren.com. Please provide as many details as possible (such as the source, price, and any pictures you may have). Our consumers are an invaluable part of Ralph Lauren’s brand protection team, and we thank you for your help!
          </div>

        </div>
      </div>
    </section>
    <br><br>
    
  </div>
  @endsection