

<?php $__env->startSection('content'); ?>


<style>
    :root {
        --bg-body: #f8fafc;
        --bg-card: #ffffff;
        --text-main: #1e293b;
        --text-muted: #64748b;
        --border-color: #e2e8f0;
        --primary: #2563eb;
        --accent: #4f46e5;
        --danger: #ef4444;
        --success: #10b981;
        --radius: 12px;
        --shadow-sm: 0 1px 2px 0 rgb(0 0 0 / 0.05);
        --shadow-md: 0 4px 6px -1px rgb(0 0 0 / 0.1);
    }

    body { background-color: var(--bg-body); font-family: 'Inter', sans-serif; font-size: 14px; color: var(--text-main); }

    /* --- LAYOUT UTILS --- */
    .page-title-box { padding: 20px 0; display: flex; align-items: center; justify-content: space-between; }
    .page-title { font-weight: 800; font-size: 24px; color: var(--text-main); margin: 0; }
    .card { border: 1px solid var(--border-color); border-radius: var(--radius); box-shadow: var(--shadow-sm); background: var(--bg-card); margin-bottom: 30px; }
    .card-body { padding: 25px; }

    /* --- BUTTONS & ACTIONS --- */
    .action-bar { display: flex; flex-wrap: wrap; gap: 10px; align-items: center; margin-bottom: 25px; }
    .btn {
        border-radius: 8px; font-weight: 600; font-size: 13px; padding: 10px 18px;
        display: inline-flex; align-items: center; justify-content: center; gap: 8px;
        transition: all 0.2s; border: 1px solid transparent; box-shadow: var(--shadow-sm);
        text-transform: capitalize; white-space: nowrap;
    }
    .btn:active { transform: translateY(1px); }
    .btn-sm { padding: 7px 14px; font-size: 12px; }

    /* =========================================
       ✅ UPDATED COLOR PALETTE (Solid Colors)
       =========================================
    */
    
    /* Danger - Solid Red */
    .btn-danger { background: #dc2626; color: #fff; border-color: #dc2626; } 
    .btn-danger:hover { background: #b91c1c; color: #fff; }
    
    /* Info - Solid Blue/Cyan */
    .btn-info { background: #0284c7; color: #fff; border-color: #0284c7; } 
    .btn-info:hover { background: #0369a1; color: #fff; }
    
    /* Success - Solid Green */
    .btn-success { background: #16a34a; color: #fff; border-color: #16a34a; } 
    .btn-success:hover { background: #15803d; color: #fff; }

    /* Primary - Solid Blue */
    .btn-primary { background: #2563eb; color: #fff; border-color: #2563eb; } 
    .btn-primary:hover { background: #1d4ed8; color: #fff; }

    /* Dark Button */
    .btn-dark { background: #1e293b; color: #ffffff !important; border-color: #0f172a; } 
    .btn-dark:hover { background: #334155; color: #ffffff !important; }

    /* Secondary */
    .btn-secondary { background: #e2e8f0; color: #1e293b; border-color: #cbd5e1; }
    .btn-secondary:hover { background: #cbd5e1; color: #1e293b; }

    .separator-v { width: 1px; height: 32px; background: var(--border-color); margin: 0 8px; }

    /* --- FILTERS & CHIPS --- */
    .filters-wrap { background: #f8fafc; border: 1px solid var(--border-color); border-radius: var(--radius); padding: 15px; margin-bottom: 25px; }
    
    /* ✅ SCROLLBAR VISIBLE CSS */
    .status-chip-row { 
        display: flex; gap: 8px; overflow-x: auto; padding-bottom: 8px; 
        scrollbar-width: thin; scrollbar-color: #cbd5e1 transparent; /* Firefox */
    }
    .status-chip-row::-webkit-scrollbar { height: 6px; display: block; } /* Webkit */
    .status-chip-row::-webkit-scrollbar-track { background: transparent; }
    .status-chip-row::-webkit-scrollbar-thumb { background-color: #cbd5e1; border-radius: 20px; }
    
    .status-chip {
        cursor: pointer; padding: 7px 14px; border-radius: 50px; background: #fff;
        border: 1px solid var(--border-color); color: var(--text-muted); font-weight: 600; font-size: 13px;
        white-space: nowrap; transition: 0.2s; display: flex; align-items: center; gap: 8px;
    }
    .status-chip:hover { border-color: var(--primary); color: var(--primary); }
    .status-chip.is-active {
        background: var(--text-main); color: #fff; border-color: var(--text-main);
        box-shadow: 0 4px 10px rgba(15, 23, 42, 0.2);
    }
    .status-chip input { display: none; }

    /* --- TABLE STYLES --- */
    .table-responsive { position: relative; }
    .order-table { width: 100%; border-collapse: separate; border-spacing: 0 10px; }
    
    /* Desktop Table Header */
    .order-table thead th {
        background: transparent; color: var(--text-muted); font-size: 11px;
        text-transform: uppercase; font-weight: 700; padding: 0 20px 10px; border: none; white-space: nowrap;
    }
    
    /* Desktop Rows */
    .order-table tbody tr {
        background: #fff; box-shadow: 0 1px 2px rgba(0,0,0,0.05); border-radius: 12px;
        transition: transform 0.2s;
    }
    .order-table tbody tr:hover { transform: translateY(-2px); box-shadow: 0 10px 20px rgba(0,0,0,0.08); z-index: 10; position: relative; }
    
    .order-table tbody td {
        padding: 16px 20px; vertical-align: middle; background: #fff;
        border-top: 1px solid var(--border-color); border-bottom: 1px solid var(--border-color);
        color: var(--text-main); font-size: 14px; white-space: nowrap;
    }
    .order-table tbody td:first-child { border-left: 1px solid var(--border-color); border-top-left-radius: 12px; border-bottom-left-radius: 12px; }
    .order-table tbody td:last-child { border-right: 1px solid var(--border-color); border-top-right-radius: 12px; border-bottom-right-radius: 12px; }

    /* Elements */
    .cell-stack { display: flex; flex-direction: column; gap: 3px; }
    .line-strong { font-weight: 700; color: var(--text-main); font-size: 14px; }
    .line-muted { color: var(--text-muted); font-size: 13px; font-weight: 500; }
    .line-small { font-size: 12px; color: #94a3b8; }
    
    .product-tag {
        background: #f1f5f9; padding: 4px 8px; border-radius: 6px; border: 1px solid #e2e8f0;
        font-size: 12px; font-weight: 600; display: inline-block; margin-bottom: 4px;
        max-width: 250px; overflow: hidden; text-overflow: ellipsis; vertical-align: middle;
    }

    .badge-soft { padding: 5px 10px; border-radius: 20px; font-weight: 700; font-size: 11px; text-transform: uppercase; }
    .bg-info-soft { background: #e0f2fe; color: #0284c7; border: 1px solid #bae6fd; }
    .bg-danger-soft { background: #fee2e2; color: #b91c1c; border: 1px solid #fecaca; }

    .action-icons { display: flex; gap: 8px; }
    .action-icon {
        width: 34px; height: 34px; display: inline-flex; align-items: center; justify-content: center;
        border-radius: 8px; background: #f8fafc; color: var(--text-muted); border: 1px solid var(--border-color);
        transition: all 0.2s; font-size: 16px; text-decoration: none;
    }
    .action-icon:hover { background: var(--primary); color: #fff; border-color: var(--primary); }
    .action-icon.delete:hover { background: var(--danger); border-color: var(--danger); }

    /* Sticky Scrollbar (Desktop) */
    .sticky-scroll-fixed {
        position: fixed; bottom: 0; z-index: 9990; height: 20px; width: 100%;
        background: rgba(255,255,255,0.9); backdrop-filter: blur(5px);
        border-top: 1px solid #cbd5e1; display: none; overflow-x: auto;
    }
    .sticky-scroll-fixed::-webkit-scrollbar { height: 12px; }
    .sticky-scroll-fixed::-webkit-scrollbar-thumb { background-color: #94a3b8; border-radius: 10px; }
    .sticky-scroll-inner { height: 1px; }

    /* Bulk Bar */
    .bulk-bar {
        position: fixed; left: 50%; bottom: 30px; transform: translateX(-50%);
        z-index: 9999; display: none; gap: 12px; padding: 10px 20px;
        background: #1e293b; border-radius: 50px; box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.2);
        color: #fff; align-items: center;
    }
    .bulk-bar .count { background: rgba(255,255,255,0.15); padding: 4px 10px; border-radius: 20px; font-weight: 700; font-size: 12px; }

    /* =========================================
       📱 MOBILE RESPONSIVE LOGIC (Long Text Fix)
       ========================================= */
    @media (max-width: 767.98px) {
        /* General Layout */
        .page-title-box { flex-direction: column; align-items: flex-start; gap: 5px; }
        .card-body { padding: 15px; }
        .separator-v { display: none; }
        
        /* Action Bar Grid */
        .action-bar { display: grid; grid-template-columns: 1fr 1fr; gap: 8px; }
        .action-bar .btn { width: 100%; justify-content: center; }

        /* Search Input */
        .filters-wrap { padding: 12px; }
        input[type="search"].form-control { font-size: 16px; /* Prevent zoom on iOS */ }

        /* TABLE TRANSFORMATION -> CARD VIEW */
        .order-table thead { display: none; }
        .order-table, .order-table tbody, .order-table tr, .order-table td { display: block; width: 100%; }
        
        /* Row as Card */
        .order-table tbody tr {
            margin-bottom: 20px; 
            padding-top: 50px; /* Space for absolute actions */
            position: relative; 
            border: 1px solid var(--border-color);
            background: #fff;
            box-shadow: 0 2px 4px rgba(0,0,0,0.03);
        }

        /* Cells inside Card - Updated for wrapping */
        .order-table td {
            display: flex; 
            justify-content: space-between; 
            align-items: flex-start; /* ✅ Aligns text to top, allowing wrapping below */
            text-align: right; 
            border-bottom: 1px dashed #e2e8f0; 
            padding: 12px 15px;
            min-height: 45px;
            white-space: normal !important; /* ✅ Allows text to wrap */
            word-break: break-word; /* ✅ Prevents overflow of long words */
        }
        .order-table td:last-child { border-bottom: none; }

        /* Labels */
        .order-table td::before {
            content: attr(data-label);
            font-weight: 700; color: var(--text-muted); font-size: 11px; 
            text-transform: uppercase; letter-spacing: 0.5px;
            text-align: left; margin-right: 15px;
            flex-shrink: 0; /* Ensures label doesn't get squashed */
            max-width: 40%;
        }

        /* Long Content Wrappers */
        .cell-stack, .product-name-wrap {
            align-items: flex-end; /* Align stack to right */
            text-align: right;
            width: 100%;
        }
        .product-tag {
            white-space: normal; /* Allow product name to wrap */
            text-align: right;
            height: auto;
            margin-bottom: 4px;
        }

        /* ABSOLUTE POSITIONING FOR HEADER ELEMENTS */
        
        /* 1. Checkbox (Top Left) */
        .order-table td[data-label="Select"] {
            position: absolute; top: 0; left: 0;
            width: 50px; height: 50px;
            border: none; padding: 0;
            display: flex; justify-content: center; align-items: center;
            background: transparent;
        }
        .order-table td[data-label="Select"] input { width: 20px; height: 20px; }

        /* 2. Action Buttons (Top Right) */
        .order-table td[data-label="Action"] {
            position: absolute; top: 8px; right: 8px;
            width: auto; height: auto;
            border: none; padding: 0; background: transparent;
        }

        /* 3. Invoice ID (Top Center / Header) */
        .order-table td[data-label="Invoice ID"] {
            display: block; text-align: center;
            background: #f8fafc;
            border-bottom: 1px solid var(--border-color);
            border-radius: 12px 12px 0 0;
            margin-top: -50px;
            height: 50px; padding-top: 14px;
            pointer-events: none;
        }
        
        /* Hide labels for absolute/special cells */
        .order-table td[data-label="Select"]::before, 
        .order-table td[data-label="Action"]::before,
        .order-table td[data-label="Invoice ID"]::before { display: none; }

        /* Bulk Bar Mobile Position */
        .bulk-bar { width: 90%; flex-wrap: wrap; justify-content: center; bottom: 20px; padding: 10px; }
    }
    
    .disable-click{ pointer-events:none; opacity: 0.7; }
</style>

<div class="row">
    <div class="col-12">
        <div class="page-title-box">
            <h4 class="page-title">Order Management</h4>
            <div class="breadcrumb-item d-none d-md-block">
                <a href="#">Dashboard</a> <span class="mx-2 text-muted">/</span> <span class="text-primary fw-bold">Order List</span>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">

                
                <div class="row mb-4">
                    <div class="col-12">
                        <div class="action-bar">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product.create')): ?>
                                <a href="<?php echo e(route('admin.orders.create')); ?>" class="btn btn-danger">
                                    <i class="mdi mdi-basket me-1"></i> New Order
                                </a>
                            <?php endif; ?>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product.edit')): ?>
                                <a class="btn_modal btn btn-info" href="<?php echo e(route('admin.assignUser')); ?>">
                                    <i class="mdi mdi-account-plus me-1"></i> Assign
                                </a>
                            <?php endif; ?>

                            <a class="btn_modal btn btn-info" href="<?php echo e(route('admin.orderStatusUpdateMulti')); ?>">
                                <i class="mdi mdi-swap-horizontal me-1"></i> Status
                            </a>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product.delete')): ?>
                                <a class="multi_order_delete btn btn-danger" href="<?php echo e(route('admin.deleteAllOrder')); ?>">
                                    <i class="mdi mdi-trash-can-outline me-1"></i> Delete
                                </a>
                            <?php endif; ?>

                            <a class="multi_order_print btn btn-success" href="<?php echo e(route('admin.orderList')); ?>">
                                <i class="mdi mdi-printer me-1"></i> Print
                            </a>

                            <div class="separator-v"></div>

                            
                            <a class="send_to_redx btn btn-dark" href="<?php echo e(route('admin.createRedxParcel')); ?>">Redx</a>
                            <a class="send_to_pathao btn btn-primary" href="<?php echo e(route('admin.createPathaoParcel')); ?>">Pathao</a>
                            <a class="send_to_steadfast btn btn-success" href="<?php echo e(route('admin.createSteadfastParcel')); ?>">Steadfast</a>

                            <button class="btn btn-secondary text-dark border" id="btn_courier_status" href="<?php echo e(route('admin.updateCourierStatus')); ?>">
                                <i class="mdi mdi-refresh me-1"></i> Courier Status
                            </button>

                            <div class="d-none">
                                <select class="select2" name="redx_status">
                                    <option value="" disabled selected>Choose Courier Status</option>
                                    <option value="">All</option>
                                    <option value="yes">Yes (<?php echo e($yes_count ?? 0); ?>)</option>
                                    <option value="no">No (<?php echo e($no_count ?? 0); ?>)</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>

                
                <div class="filters-wrap">
                    <form id="filter_form">
                        <div class="d-flex flex-wrap align-items-center gap-3">
                            <div style="flex-grow: 1; overflow: hidden;">
                                <div class="status-chip-row">
                                    
                                    <?php $__currentLoopData = getOrderStatus(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <label class="status-chip" data-status="<?php echo e($key); ?>">
                                            <input type="radio" class="order_sts" name="status" value="<?php echo e($key); ?>"/>
                                            <span><?php echo e($value); ?></span>
                                            <span style="background: rgba(0,0,0,0.06); padding: 2px 8px; border-radius: 10px; font-size: 11px;">
                                                <?php if(Auth::user()->hasRole('worker')): ?>
                                                    <?php echo e(\App\Models\Order::whereHas('details.product', function($q){ $q->whereNotNull('name'); })->where('status',$key)->where('assign_user_id',Auth::user()->id)->count()); ?>

                                                <?php else: ?>
                                                    <?php echo e(\App\Models\Order::whereHas('details.product', function($q){ $q->whereNotNull('name'); })->where('status',$key)->count()); ?>

                                                <?php endif; ?>
                                            </span>
                                        </label>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    

                                    

                                    
                                </div>
                            </div>
                            <div style="min-width: 280px; display:flex; gap:8px;">
                                <input type="search" class="form-control w-100" placeholder="Search orders..." name="q" autocomplete="off">
                                <button type="button" class="btn btn-dark" id="submit_search">
                                    <i class="mdi mdi-magnify"></i> Search
                                </button>
                            </div>
                        </div>
                    </form>
                </div>

                
                <div class="col-sm-12 mt-3" id="rcvd_order">
                    <div class="table-responsive" id="orderTableWrap">
                        <table class="table order-table">
                            <thead>
                                <tr>
                                    <th style="width:50px">
                                        <div class="form-check d-flex justify-content-center">
                                            <input type="checkbox" class="form-check-input check_all" value="">
                                        </div>
                                    </th>
                                    <th style="width:100px">Action</th>
                                    <th>Invoice ID</th>
                                    <th>Order Info</th>
                                    <th>Date</th>
                                    <th>Time</th>
                                    <th>Customer</th>
                                    <th>Products</th>
                                    <th>SKU</th>
                                    <th>Variant</th>
                                    <th>Status</th>
                                    <th>Fraud Check</th>
                                    <th>Payment</th>
                                    <th>Assigned</th>
                                    <th>Courier</th>
                                    <th>Courier Sts</th>
                                    <th>Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="touch-check" data-label="Select">
                                        <div class="d-flex justify-content-center">
                                            <input type="checkbox" class="order_checkbox form-check-input" style="width:18px; height:18px;" value="<?php echo e($item->id); ?>">
                                        </div>
                                    </td>
                                    
                                    <td data-label="Action">
                                        <div class="action-icons">
                                            <a href="<?php echo e(route('admin.orders.edit',[$item->id])); ?>" class="action-icon" title="Edit"><i class="mdi mdi-pencil-outline"></i></a>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('order.delete')): ?>
                                                <a href="<?php echo e(route('admin.orders.destroy',[$item->id])); ?>" class="delete action-icon" title="Delete"><i class="mdi mdi-trash-can-outline"></i></a>
                                            <?php endif; ?>
                                        </div>
                                    </td>

                                    <td data-label="Invoice ID">
                                        <div class="line-strong text-primary">#<?php echo e($item->invoice_no); ?></div>
                                    </td>

                                    <td data-label="Order ID & Name">
                                        <div class="cell-stack">
                                            <div class="line-strong">ID: <?php echo e($item->id); ?></div>
                                            <div class="line-muted"><?php echo e(trim(($item->first_name ?? '').' '.($item->last_name ?? ''))); ?></div>
                                        </div>
                                    </td>

                                    <td data-label="Date Order">
                                        <div class="line-strong"><?php echo e(dateFormate($item->date)); ?></div>
                                    </td>

                                    <td data-label="Order Time">
                                        <div class="line-muted"><?php echo e($item->created_at->diffForHumans()); ?></div>
                                    </td>

                                    <td data-label="Customers">
                                        <div class="cell-stack">
                                            <div class="line-strong"><?php echo e($item->first_name.' '.$item->last_name); ?></div>
                                            <div class="line-small text-muted"><?php echo e($item->shipping_address); ?></div>
                                            <a class="line-small text-primary fw-bold text-decoration-none" href="tel:<?php echo e(preg_replace('/\D/','',$item->mobile)); ?>">
                                                <i class="mdi mdi-phone"></i> <?php echo e($item->mobile); ?>

                                            </a>
                                        </div>
                                    </td>

                                    <td data-label="Product Name">
                                        <div class="product-name-wrap d-flex flex-column">
                                            <?php $__currentLoopData = $item->details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <span class="product-tag"><?php echo e($detail->product->name ?? 'Unknown Product'); ?></span>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </td>

                                    <td data-label="Product SKU">
                                        <div class="cell-stack">
                                            <?php
                                              foreach($item->details as $detail){
                                                if(!isset($detail->product['sku']) || $detail->product['sku'] == ''){
                                                  echo '<span class="line-small text-danger fw-bold">Unavailable</span>';
                                                } else {
                                                  echo '<span class="line-small fw-bold text-dark">'.e($detail->product['sku']).'</span>';
                                                }
                                                echo "<br>";
                                              }
                                            ?>
                                        </div>
                                    </td>

                                    <td data-label="Variant">
                                        <div class="cell-stack">
                                            <?php
                                              foreach($item->details as $detail){
                                                echo '<span class="line-small fw-bold">';
                                                if(!empty($detail->variant_name)){ echo e($detail->variant_name); }
                                                elseif(isset($detail->variation) && !empty($detail->variation->display_title)){ echo e($detail->variation->display_title); }
                                                else {
                                                    $size = $detail->variation->size_label ?? $detail->variation->size ?? null;
                                                    $color = $detail->variation->color_label ?? $detail->variation->color ?? null;
                                                    if($size || $color){ echo e(trim(($size ?? '').($color ? (' - '.$color):''))); }
                                                    else{ echo "—"; }
                                                }
                                                echo '</span><br>';
                                              }
                                            ?>
                                        </div>
                                    </td>

                                    <td data-label="Status">
                                        <a class="btn_modal" href="<?php echo e(route('admin.orderStatus', $item->id)); ?>" style="text-decoration:none;">
                                            <span class="badge-soft bg-info-soft"><?php echo e($item->status); ?></span>
                                        </a>
                                    </td>

                                    <td data-label="Fraud Check">
                                        <?php $percent =$item->getCourierPercent(); ?>
                                        <?php $color = $percent>50 ? '#10b981' : ($percent>20?'#f59e0b':'#ef4444'); ?>
                                        <div style="display:flex; align-items:center; gap:8px;">
                                            <span style="color:<?php echo e($color); ?>; font-weight:800; font-size:15px;"><?php echo e($percent); ?>%</span>
                                            <a href="javascript:void(0);" data-url="<?php echo e(route('admin.fraudOrderCheck',$item->id)); ?>" class="btn-fraud action-icon" style="width:28px; height:28px;">
                                                <i class="mdi mdi-magnify" style="font-size:16px;"></i>
                                            </a>
                                        </div>
                                    </td>

                                    
                                    <td data-label="Payment Status">
                                        <a class="btn_modal" href="<?php echo e(route('admin.order_payments.edit', $item->id)); ?>" style="text-decoration:none;">
                                            <?php if(strtolower($item->payment_status ?? '') == 'paid'): ?>
                                                <span class="badge-soft" style="background:#dcfce7; color:#166534; border:1px solid #bbf7d0;">Paid</span>
                                                <?php if($item->transaction_id): ?>
                                                    <div class="mt-1" style="font-size:10px; color:#64748b; white-space: normal; line-height: 1.2;">
                                                        <i class="mdi mdi-credit-card-check-outline"></i> <?php echo e($item->transaction_id); ?>

                                                    </div>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <span class="badge-soft bg-danger-soft"><?php echo e($item->payment_status ?? 'Due'); ?></span>
                                            <?php endif; ?>
                                        </a>
                                    </td>

                                    <td data-label="Assign User">
                                        <span class="line-strong" style="font-size:13px;"><?php echo e($item->assign ? $item->assign->username : '—'); ?></span>
                                    </td>

                                    <td data-label="Courier">
                                        <div class="cell-stack">
                                            <span class="line-strong" style="font-size:13px;"><?php echo e($item->courier ? $item->courier->name : '—'); ?></span>
                                            <span class="line-small text-muted"><?php echo e($item->courier_tracking_id ?? ''); ?></span>
                                            <?php if($item->courier_id==1 && $item->courier_tracking_id): ?>
                                              <a href="https://redx.com.bd/track-global-parcel/?trackingId=<?php echo e($item->courier_tracking_id); ?>" target="_blank" class="line-small text-primary fw-bold">Track Redx</a>
                                            <?php elseif($item->courier_id==3 && $item->courier_tracking_code): ?>
                                              <a href="https://steadfast.com.bd/t/<?php echo e($item->courier_tracking_code); ?>" target="_blank" class="line-small text-primary fw-bold">Track SF</a>
                                            <?php elseif($item->courier_id==2 && $item->courier_tracking_id): ?>
                                              <a href="https://merchant.pathao.com/tracking?consignment_id=<?php echo e($item->courier_tracking_id); ?>" target="_blank" class="line-small text-primary fw-bold">Track Pathao</a>
                                            <?php endif; ?>
                                        </div>
                                    </td>

                                    <td data-label="Courier Status">
                                        <span class="line-muted"><?php echo e($item->courier_status ?? '—'); ?></span>
                                    </td>

                                    <td data-label="Amount">
                                        <span class="line-strong fs-6"><?php echo e((int) $item->final_amount); ?></span>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-4 pagination-wrap d-flex justify-content-end">
                        <?php echo urldecode(str_replace("/?","?",$items->appends(Request::all())->render())); ?>

                    </div>
                </div>

                
                <div id="stickyScrollWrap" class="sticky-scroll-fixed">
                    <div id="stickyScrollBar" class="sticky-scroll-inner"></div>
                </div>

            </div>
        </div>
    </div>
</div>


<div class="modal fade orderFraudModal" id="fraudModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content" style="border-radius:16px; border:none; overflow: hidden;">
            <div class="modal-header border-bottom-0 bg-light py-3">
                <h5 class="modal-title fw-bold text-dark">Fraud Check Analysis</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body p-4 orderFraud bg-white">Loading...</div>
        </div>
    </div>
</div>

<div class="bulk-bar" id="bulkBar">
    <span class="count" id="bulkCount">0 Selected</span>
    <button type="button" class="btn btn-sm btn-info text-white" id="bb-assign"><i class="mdi mdi-account-plus me-1"></i> Assign</button>
    <button type="button" class="btn btn-sm btn-secondary text-dark border-0" id="bb-status"><i class="mdi mdi-swap-horizontal me-1"></i> Status</button>
    <button type="button" class="btn btn-sm btn-success text-white" id="bb-print"><i class="mdi mdi-printer me-1"></i> Print</button>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product.delete')): ?>
        <button type="button" class="btn btn-sm btn-danger text-white" id="bb-delete"><i class="mdi mdi-delete-outline me-1"></i> Delete</button>
    <?php endif; ?>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('backend/js/order.js')); ?>"></script>
<script>
$(function(){

    /* ----------------------------------------------------------- */
    /* UI INIT FUNCTIONS (Sticky Scroll & Chips)                   */
    /* ----------------------------------------------------------- */
    function initStickyHorizontalScroll(){
        const $tableContainer = $('#rcvd_order .table-responsive');
        const $table          = $tableContainer.find('table');
        const $stickyWrap     = $('#stickyScrollWrap');
        const $stickyInner    = $('#stickyScrollBar');
        const $bulkBar        = $('#bulkBar');

        // Prevent Sticky Scroll on Mobile (We use Card View)
        if(window.innerWidth < 768) {
            $stickyWrap.hide(); return;
        }

        if(!$tableContainer.length || !$stickyWrap.length) return;

        function syncDimensions() {
            if(!$table.length) return;
            const tableWidth = $table.outerWidth();
            const containerWidth = $tableContainer.width();
            const containerLeft = $tableContainer.offset().left;
            
            if (tableWidth > containerWidth) {
                $stickyWrap.show();
                $stickyWrap.css({ 'width': containerWidth + 'px', 'left': containerLeft + 'px' });
                $stickyInner.css('width', tableWidth + 'px');
                
                if($bulkBar.is(':visible')){
                   $stickyWrap.css('bottom', ($bulkBar.outerHeight() + 25) + 'px');
                } else {
                   $stickyWrap.css('bottom', '0px');
                }
            } else {
                $stickyWrap.hide();
            }
        }

        $stickyWrap.off('scroll.sticky').on('scroll.sticky', function(){
            $tableContainer.scrollLeft($(this).scrollLeft());
        });
        $tableContainer.off('scroll.table').on('scroll.table', function(){
            $stickyWrap.scrollLeft($(this).scrollLeft());
        });

        syncDimensions();
        $(window).off('resize.sticky').on('resize.sticky', syncDimensions);
        window.refreshStickyPos = syncDimensions; 
    }

    function syncActiveChip(){
        const $checked = $(".order_sts:checked");
        $('.status-chip').removeClass('is-active');
        if($checked.length) $checked.closest('.status-chip').addClass('is-active');
    }

    /* ----------------------------------------------------------- */
    /* CORE LOGIC (Restoring ALL Logic from Code 2)                */
    /* ----------------------------------------------------------- */

    // Fraud modal
    $(document).on('click', '.btn-fraud', function (e) {
        e.preventDefault();
        const url = $(this).data('url');
        $.get(url, function (response) {
            $('.orderFraudModal .orderFraud').html(response);
            $('.orderFraudModal').modal('show');
        });
    });

    // Filters
    $("select[name='redx_status']").on('change', getOrderList);
    $("select[name='courier_type']").on('change', getOrderList);
    
    // Status Chip Click
    $('.order_sts').on('change', function(){
        syncActiveChip();
        getOrderList();
    });

    function getOrderList(){
        const statusValue = $("input[name='status']:checked").val();
        const redx_status = $("select[name='redx_status']").val();
        const courier_type = $("select[name='courier_type']").val();
        $.ajax({
            type: 'GET',
            url: "<?php echo e(route('admin.status_wise_order')); ?>",
            data: {statusValue, redx_status, courier_type},
            success: function(res){
                if(res.success === true){ 
                    $('#rcvd_order').html(res.view); 
                    afterRender(); 
                    initStickyHorizontalScroll(); // Re-init scroll
                }
            }
        });
    }

    // Search
    $('#submit_search').on('click', function(){
        const searchValue = $("input[name='q']").val();
        $.ajax({
            type: 'GET',
            url: "<?php echo e(route('admin.searchOrder')); ?>",
            data: {searchValue},
            success: function(res){
                if(res.success === true){ 
                    $('#rcvd_order').html(res.view); 
                    afterRender(); 
                    initStickyHorizontalScroll(); // Re-init scroll
                }
            }
        });
    });

    // Checkbox + bulk bar
    function refreshBulk(){
        const cnt = $('input.order_checkbox:checked').length;
        $('#bulkCount').text(cnt + ' Selected');
        if(cnt > 0){ 
            $('#bulkBar').fadeIn(150, function(){ if(window.refreshStickyPos) window.refreshStickyPos(); }); 
        } else { 
            $('#bulkBar').fadeOut(150, function(){ if(window.refreshStickyPos) window.refreshStickyPos(); }); 
        }
    }

    function afterRender(){
        $(".check_all").off('change').on('change',function(){
            $(".order_checkbox").prop('checked',$(this).is(":checked"));
            refreshBulk();
        });
        $(document).off('change','.order_checkbox').on('change','.order_checkbox', refreshBulk);
    }

    /* Initialize */
    afterRender();
    initStickyHorizontalScroll();
    syncActiveChip();

    // Multi status
    $(document).on('submit', 'form#order_status_update_form', function(e){
        e.preventDefault();
        const url = $(this).attr('action');
        const status = $('#multi_status').val();
        const order_ids = $('input.order_checkbox:checked').map(function(){ return $(this).val(); }).get();
        if(!order_ids.length){ toastr.error('Please Select An Order First !'); return; }
        $.get(url, {status,order_ids}, function(res){
            if(res.status){ toastr.success(res.msg); location.reload(); }
            else{ toastr.error(res.msg); }
        });
    });

    // Assign user
    $(document).on('submit', 'form#order_assign_form', function(e){
        e.preventDefault();
        const url = $(this).attr('action');
        const assign_user_id = $('#assign_user_id').val();
        const order_ids = $('input.order_checkbox:checked').map(function(){ return $(this).val(); }).get();
        if(!order_ids.length){ toastr.error('Please Select An Order First !'); return; }
        $.get(url, {assign_user_id,order_ids}, function(res){
            if(res.status){ toastr.success(res.msg); location.reload(); }
            else{ toastr.error(res.msg); }
        });
    });

    // Delete
    $(document).on('click', 'a.multi_order_delete', function(e){
        e.preventDefault();
        const url = $(this).attr('href');
        const order_ids = $('input.order_checkbox:checked').map(function(){ return $(this).val(); }).get();
        if(!order_ids.length){ toastr.error('Please Select An Order First !'); return; }
        $.get(url, {order_ids}, function(res){
            if(res.status){ toastr.success(res.msg); location.reload(); }
            else{ toastr.error(res.msg); }
        });
    });

    // Print
    $(document).on('click', 'a.multi_order_print', function(e){
        e.preventDefault();
        const url = $(this).attr('href');
        const order_ids = $('input.order_checkbox:checked').map(function(){ return $(this).val(); }).get();
        if(!order_ids.length){ toastr.error('Please Select Atleast One Order!'); return; }
        $.get(url, {order_ids}, function(res){
            if(res.status){
                const w = window.open("", "_blank");
                w.document.write(res.view);
            }else{ toastr.error(res.msg); }
        });
    });

    // Courier status update
    $(document).on('click', '#btn_courier_status', function(e){
        e.preventDefault();
        const url = $(this).attr('href');
        const link = $(this);
        const order_ids = $('input.order_checkbox:checked').map(function(){ return $(this).val(); }).get();
        if(!order_ids.length){ toastr.error('Please Select Atleast One Order!'); return; }
        if(confirm('Are you sure?')){
            $.ajax({
                type:'GET', url, data:{order_ids},
                beforeSend: function(){ link.addClass('disable-click').text('Please wait...'); },
                success:function(res){
                    link.removeClass('disable-click').html('<i class="mdi mdi-refresh me-1"></i> Courier Status');
                    if(res.status){ toastr.success(res.msg); }
                    else{ toastr.error(`Invoice No. : ${res.invoice} something went wrong!`); }
                }
            });
        }
    });

    // Send to couriers
    function sendToCourier(link, label){
        const url = link.attr('href');
        const order_ids = $('input.order_checkbox:checked').map(function(){ return $(this).val(); }).get();
        if(!order_ids.length){ toastr.error('Please Select Atleast One Order!'); return; }
        $.ajax({
            type:'GET', url, data:{order_ids},
            beforeSend: function(){ link.addClass('disable-click').text('Please wait...'); },
            success:function(res){
                link.removeClass('disable-click').text(label);
                if(res.status){ toastr.success(res.msg); }
                else{ toastr.error(`Invoice :${res.invoice} something went wrong!`); }
            }
        });
    }
    $(document).on('click', 'a.send_to_redx', function(e){ e.preventDefault(); sendToCourier($(this),'Redx'); });
    $(document).on('click', 'a.send_to_pathao', function(e){ e.preventDefault(); sendToCourier($(this),'Pathao'); });
    $(document).on('click', 'a.send_to_steadfast', function(e){ e.preventDefault(); sendToCourier($(this),'Steadfast'); });

    // Sticky Bulk Bar shortcuts
    $('#bb-assign').on('click', function(){ $('.btn_modal[href="<?php echo e(route('admin.assignUser')); ?>"]').trigger('click'); });
    $('#bb-status').on('click', function(){ $('.btn_modal[href="<?php echo e(route('admin.orderStatusUpdateMulti')); ?>"]').trigger('click'); });
    $('#bb-print').on('click', function(){ $('.multi_order_print').trigger('click'); });
    $('#bb-delete').on('click', function(){ $('.multi_order_delete').trigger('click'); });
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('backend.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\php8212\htdocs\ecommerce\resources\views/backend/orders/index.blade.php ENDPATH**/ ?>