

<?php
    use App\Models\Information;
    use Illuminate\Support\Facades\DB;

    // ✅ Always load latest row (so DB update instantly reflects)
    $info = Information::orderBy('id','desc')->first();

    // ✅ fallback safety
    $ownerPhone = $info->owner_phone ?? '';
    $ownerEmail = $info->owner_email ?? '';

    // ✅ WhatsApp sanitize (whats_num priority, fallback owner_phone)
    $whatsNumberRaw = $info->whats_num ?? $ownerPhone ?? '';
    $whatsNumber = preg_replace('/[^0-9]/', '', $whatsNumberRaw);

    // ✅ normalize BD number for wa.me (needs country code)
    if (substr($whatsNumber, 0, 2) === '01') {
        $whatsNumber = '88' . $whatsNumber; // 8801xxxxxxxxx
    } elseif (substr($whatsNumber, 0, 3) === '880') {
        // ok
    } elseif (substr($whatsNumber, 0, 2) === '88') {
        // ok
    } else {
        if (strlen($whatsNumber) === 11 && substr($whatsNumber, 0, 1) === '1') {
            $whatsNumber = '88' . $whatsNumber;
        }
    }
?>

<style>
    /* ===========================
       ✅ DB driven theme variables
       =========================== */
    :root{
        --footer-bg1: <?php echo e($info->footer_bg1 ?? '#0f172a'); ?>;
        --footer-bg2: <?php echo e($info->footer_bg2 ?? '#020617'); ?>;
        --footer-bg3: <?php echo e($info->footer_bg3 ?? '#000000'); ?>;

        --footer-text: <?php echo e($info->footer_text ?? '#e5e7eb'); ?>;
        --footer-hover: <?php echo e($info->footer_link_hover ?? '#38bdf8'); ?>;
        --footer-subtitle: <?php echo e($info->footer_subtitle ?? '#9ca3af'); ?>;

        --footer-grad1: <?php echo e($info->footer_border_grad1 ?? '#22d3ee'); ?>;
        --footer-grad2: <?php echo e($info->footer_border_grad2 ?? '#2563eb'); ?>;

        --pill-bg: <?php echo e($info->footer_pill_bg ?? '#0f172a'); ?>;
        --pill-border: <?php echo e($info->footer_pill_border ?? '#94a3b8'); ?>;
        --pill-hover-bg: <?php echo e($info->footer_pill_hover_bg ?? '#0ea5e9'); ?>;
        --pill-hover-text: <?php echo e($info->footer_pill_hover_text ?? '#0b1120'); ?>;

        --underline: <?php echo e($info->footer_underline ?? '#38bdf8'); ?>;

        --social-border: <?php echo e($info->footer_social_border ?? '#94a3b8'); ?>;
        --social-bg: <?php echo e($info->footer_social_bg ?? '#0f172a'); ?>;
        --social-hover-bg: <?php echo e($info->footer_social_hover_bg ?? '#0ea5e9'); ?>;
        --social-hover-text: <?php echo e($info->footer_social_hover_text ?? '#020617'); ?>;

        --mnav-bg: <?php echo e($info->mnav_bg ?? '#ffffff'); ?>;
        --mnav-border: <?php echo e($info->mnav_border ?? '#e5e7eb'); ?>;
        --mnav-icon: <?php echo e($info->mnav_icon ?? '#1e65b2'); ?>;

        --mnav-home-bg: <?php echo e($info->mnav_home_bg ?? '#00276C'); ?>;
        --mnav-home-border: <?php echo e($info->mnav_home_border ?? '#ffffff'); ?>;
        --mnav-home-icon: <?php echo e($info->mnav_home_icon ?? '#ffffff'); ?>;
    }

/* ✅ Address (footer tagline) = footer text color */
.footer-tagline,
.footer-tagline i{
    color: var(--footer-text) !important;
    opacity: 1 !important; /* opacity-75 override */
}

/* ✅ Contact label = footer text color */
.footer-contact-label{
    color: var(--footer-text) !important;
    opacity: 1 !important; /* আগের opacity .85 override */
    margin-right:4px;
    font-weight:600;
}


    .footer-modern{
        /* ✅ IMPORTANT FIX: main-bg override prevent */
        background: radial-gradient(circle at top left, var(--footer-bg1) 0%, var(--footer-bg2) 55%, var(--footer-bg3) 100%) !important;

        color: var(--footer-text);
        font-family: 'Hind Siliguri', system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;

        border-top:1px solid transparent;
        border-image: linear-gradient(to right, var(--footer-grad1), var(--footer-grad2));
        border-image-slice: 1;
    }
    .footer-modern a{ color: var(--footer-text); text-decoration:none; transition: all .2s ease; }
    .footer-modern a:hover{ color: var(--footer-hover); }

    .footer-top-row{ align-items:flex-start !important; }
    @media (min-width: 768px){
        .footer-col{ display:flex; flex-direction:column; justify-content:flex-start; }
    }

    .footer-logo-img{
        max-height:60px;
        width:auto;
        object-fit:contain;
        filter: drop-shadow(0 0px 0px rgba(0,0,0,.45));
    }

    .footer-title{
        font-size:1.15rem;
        font-weight:700;
        letter-spacing:.04em;
        text-transform:uppercase;
    }
    .footer-title-small{
        font-size:1.10rem;
        font-weight:700;
        letter-spacing:.10em;
        text-transform:uppercase;
        opacity:.95;
    }
    .footer-subtitle{ color: var(--footer-subtitle); font-size:14px; }

    .footer-links{ row-gap:.55rem; position:relative; z-index:2; }

    .footer-pill-link{
        font-size:14px;
        padding:.3rem .85rem;
        border-radius:999px;

        background: color-mix(in srgb, var(--pill-bg) 55%, transparent);
        border-color: color-mix(in srgb, var(--pill-border) 35%, transparent);
        border-style: solid;
        border-width: 1px;

        white-space:nowrap;
        box-shadow:0 0px 0px rgba(15,23,42,.35);
        transition: all .2s ease;
        display:inline-flex; align-items:center; justify-content:center;
        position:relative; z-index:5; pointer-events:auto; cursor:pointer;
    }
    .footer-pill-link:hover{
        background: var(--pill-hover-bg) !important;
        border-color: var(--pill-hover-bg) !important;
        color: var(--pill-hover-text) !important;
        transform:translateY(-1px);
        box-shadow:0 0px 0px rgba(15,23,42,.6);
    }

    .footer-legal-links{ gap:12px 18px; }
    .footer-link-underline{ font-size:14px; position:relative; padding-bottom:3px; padding-right:2px; }
    .footer-link-underline::after{
        content:""; position:absolute; left:0; bottom:0;
        width:0; height:2px; background: var(--underline); transition:width .2s;
    }
    .footer-link-underline:hover::after{ width:100%; }

    .footer-contact{ font-size:14px; }
    .footer-contact li{ margin-bottom:6px; }
    .footer-contact-label{ opacity:.85; margin-right:4px; font-weight:600; }

    .footer-copy{ font-size:13px; }

    .footer-social-icon{
        width:34px; height:34px; border-radius:999px;
        border:1px solid color-mix(in srgb, var(--social-border) 50%, transparent);

        display:flex; align-items:center; justify-content:center;
        font-size:15px;

        background: color-mix(in srgb, var(--social-bg) 70%, transparent);

        box-shadow:0 0px 0px rgba(15,23,42,.6);
        transition: all .2s ease;
    }
    .footer-social-icon:hover{
        background: var(--social-hover-bg);
        border-color: var(--social-hover-bg);
        color: var(--social-hover-text);
        transform:translateY(-1px) scale(1.02);
    }

    @media (max-width: 767.98px){
        .footer-modern{ text-align:center; }
        .footer-modern .footer-title,
        .footer-modern .footer-title-small,
        .footer-modern .footer-copy{ text-align:center; }
    }

    /* ✅ UPDATE: Sleek Premium Payment Box */
    .premium-payment-box {
        display: inline-block;
        background: #ffffff;
        padding: 8px 15px; /* ✅ প্যাডিং কমানো হয়েছে */
        border-radius: 10px; /* ✅ রেডিয়াস একটু ছোট করা হয়েছে */
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.4);
        margin-top: 20px;
        border: 2px solid rgba(255, 255, 255, 0.1);
        max-width: 95%; /* মোবাইল সেফটি */
    }
    .premium-payment-box img {
        display: block;
        max-width: 100%;
        height: auto;
        max-height: 60px; /* ✅ ইমেজের হাইট লিমিট করে দেওয়া হয়েছে যাতে বেশি বড় না দেখায় */
    }

    /* ===========================
       ✅ MOBILE BOTTOM NAV (DB)
       =========================== */
    .footer-nav{
        position: fixed;
        bottom: 0;
        left: 0;
        width: 100%;
        background: var(--mnav-bg);
        border-top:1px solid var(--mnav-border);
        box-shadow:0 -6px 22px rgba(15,23,42,.18);
        z-index: 99999;
        display:none;
    }
    .m-nav-main{
        display:flex;
        justify-content: space-evenly;
        align-items:flex-end;
        padding:6px 10px 8px;
        gap: 6px;
    }
    .button-shop{
        flex:1;
        text-align:center;
        font-size:12px;
        font-weight:600;
        position:relative;
    }
    .footerBtn{
        display:flex;
        flex-direction:column;
        align-items:center;
        justify-content:center;
        gap:2px;
        text-decoration:none;
        -webkit-tap-highlight-color: transparent;
        user-select:none;
        width:100%;
    }
    .footerBtn i{ font-size:20px; color: var(--mnav-icon); line-height:1; }
    .footerBtn span{ font-size:12px; color: var(--mnav-icon); line-height:1.1; }

    .home-center{ flex:1; }
    .home-center .footerBtn{
        width:64px;
        height:64px;
        margin: -28px auto 0;
        border-radius:999px;
        background: var(--mnav-home-bg);
        box-shadow:0 14px 28px rgba(0,0,0,.25);
        border:3px solid var(--mnav-home-border);
        justify-content:center;
        padding: 0;
    }
    .home-center .footerBtn i{ font-size:22px; color: var(--mnav-home-icon); }
    .home-center .footerBtn span{ font-size:11px; color: var(--mnav-home-icon); margin-top:-2px; }

    .footerBtn:active{ transform: scale(.98); }

    @media (max-width: 575.98px){
        .footer-nav{ display:block; }
        body{ padding-bottom:80px; }
    }
</style>


<footer class="footer-modern text-light pt-5 pb-4 border-top border-secondary">
    <div class="container">
        
        <div class="row gy-4 footer-top-row">

            
            <div class="col-md-3 text-center text-md-start">
                <a href="<?php echo e(route('front.home')); ?>" class="footer-logo-link d-inline-flex align-items-center justify-content-center">
                    <img
                        src="<?php echo e(asset('uploads/img/'.(!empty($info->footer_logo) ? $info->footer_logo : ($info->site_logo ?? '')))); ?>"
                        alt="Logo"
                        class="footer-logo-img img-fluid"
                    >
                </a>
                <?php if(!empty($info->address)): ?>
                    <p class="footer-tagline mt-3 mb-0 opacity-75">
                        <i class="fa fa-map-marker-alt me-1"></i> <?php echo e($info->address); ?>

                    </p>
                <?php endif; ?>
            </div>

            
            <div class="col-md-5 footer-col">
                <h5 class="footer-title mb-2 text-center text-md-start">Popular Categories</h5>
                <p class="footer-subtitle mb-3 text-center text-md-start">Top picks from our best-selling sections</p>

                <nav class="footer-links d-flex flex-wrap gap-2 justify-content-center justify-content-md-start">
                    <?php $__currentLoopData = DB::table('categories')->where('is_popular', 1)->take(6)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a href="<?php echo e(route('front.subCategories1',[$cat->url])); ?>" class="footer-pill-link">
                            <?php echo e($cat->name); ?>

                        </a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </nav>
            </div>

            
            <div class="col-md-4 text-center text-md-end footer-col">
                <h5 class="footer-title mb-2">Contact & Social</h5>
                <p class="footer-subtitle mb-3 text-center text-md-end">Need help? We’re just one call away.</p>

                <ul class="list-unstyled mb-3 footer-contact">
                    <?php if(!empty($ownerPhone)): ?>
                        <li>
                            <span class="footer-contact-label"><i class="fa fa-phone me-1"></i> Call:</span>
                            <a href="tel:<?php echo e($ownerPhone); ?>"><?php echo e($ownerPhone); ?></a>
                        </li>
                    <?php endif; ?>
                    <?php if(!empty($ownerEmail)): ?>
                        <li>
                            <span class="footer-contact-label"><i class="fa fa-envelope me-1"></i> Email:</span>
                            <a href="mailto:<?php echo e($ownerEmail); ?>"><?php echo e($ownerEmail); ?></a>
                        </li>
                    <?php endif; ?>
                </ul>

                <div class="footer-social d-inline-flex flex-wrap justify-content-center justify-content-md-end gap-2">
                    <?php if(!empty($info->facebook)): ?>
                        <a href="<?php echo e($info->facebook); ?>" target="_blank" class="footer-social-icon"><i class="fab fa-facebook-f"></i></a>
                    <?php endif; ?>
                    <?php if(!empty($info->youtube)): ?>
                        <a href="<?php echo e($info->youtube); ?>" target="_blank" class="footer-social-icon"><i class="fab fa-youtube"></i></a>
                    <?php endif; ?>
                    <?php if(!empty($info->instagram)): ?>
                        <a href="<?php echo e($info->instagram); ?>" target="_blank" class="footer-social-icon"><i class="fab fa-instagram"></i></a>
                    <?php endif; ?>
                    <?php if(!empty($info->tiktok)): ?>
                        <a href="<?php echo e($info->tiktok); ?>" target="_blank" class="footer-social-icon"><i class="fab fa-tiktok"></i></a>
                    <?php endif; ?>
                    <?php if(!empty($info->twitter)): ?>
                        <a href="<?php echo e($info->twitter); ?>" target="_blank" class="footer-social-icon"><span style="font-family: system-ui;">𝕏</span></a>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        
        <div class="row mt-4 pt-3 border-top border-secondary-subtle">
            <div class="col-md-8 mb-3 mb-md-0">
                <h6 class="footer-title-small text-center text-md-start mb-2">Legal Pages</h6>

                <nav class="footer-links footer-legal-links d-flex flex-wrap justify-content-center justify-content-md-start">
                    <?php $__currentLoopData = DB::table('pages')->take(6)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a href="<?php echo e(route('front.page.name', $page->page)); ?>" class="footer-link-underline">
                            <?php echo e($page->title); ?>

                        </a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </nav>
            </div>

            <div class="col-md-4 text-center text-md-end">
                <small class="footer-copy d-block mt-3 mt-md-0">
                    <?php echo $info->copyright ?? ''; ?>

                    <a href="https://www.facebook.com/bizcareit" target="_blank" rel="noopener noreferrer">
                        Design & Development by Biz Care IT
                    </a>
                </small>
            </div>
        </div>

        
        <div class="row">
            <div class="col-12 text-center">
                <div class="premium-payment-box">
                    <img 
                        src="<?php echo e(asset('frontend/images/ssl.png')); ?>" 
                        alt="We Accept Secure Payment" 
                        class="img-fluid"
                    >
                </div>
            </div>
        </div>
        

    </div>
</footer>


<div class="footer-nav d-sm-block d-md-none">
    <div class="m-nav-main">

        
        <div class="button-shop">
            <a href="#" class="footerBtn mobile-nav-toggler">
                <i class="fa fa-bars"></i>
                <span>Categories</span>
            </a>
        </div>

        
        <div class="button-shop">
            <a href="<?php echo e(!empty($whatsNumber) ? 'https://wa.me/'.$whatsNumber : '#'); ?>"
               class="footerBtn" target="_blank" rel="noopener">
                <i class="fab fa-whatsapp"></i>
                <span>WhatsApp</span>
            </a>
        </div>

        
        <div class="button-shop home-center">
            <a href="<?php echo e(route('front.home')); ?>" class="footerBtn" aria-label="Home">
                <i class="fa fa-home"></i>
                <span>Home</span>
            </a>
        </div>

        
        <div class="button-shop">
            <a href="<?php echo e(route('front.products.index')); ?>" class="footerBtn">
                <i class="fa fa-store"></i>
                <span>Shop</span>
            </a>
        </div>

        
        <div class="button-shop">
            <a href="<?php echo e(!empty($ownerPhone) ? 'tel:'.$ownerPhone : '#'); ?>" class="footerBtn">
                <i class="fa fa-phone-volume"></i>
                <span>Call</span>
            </a>
        </div>

    </div>
</div>


<div class="cart-dropdown" id="cart-dropdown"></div>
<?php echo $__env->make('frontend.partials.js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/chirkut1/public_html/resources/views/frontend/partials/footer.blade.php ENDPATH**/ ?>