

<?php
    use App\Models\AdminText;

    $dt   = AdminText::first();
    // Ensure $info is available (usually passed from parent controller/view composer)
    // If $info is not passed, we handle defaults below
    $curr = $info->currency ?? 'BDT';

    $singleProduct->loadMissing(['variations.size','variations.color','variations.stocks','reviews','images','category']);

    /* ✅ DB default (id=1) hide from popup */
    $DEFAULT_SIZE_ID  = 1; // Assuming 1 based on first line, but later overridden to 3 in your snippet.
    $DEFAULT_COLOR_ID = 1;
    $DEFAULT_SIZE_ID  = 3; // Kept as per your snippet

    $varMap    = [];
    $sizesMap  = [];
    $colorsMap = [];

    if($singleProduct->variations && $singleProduct->variations->count() > 0){
        foreach($singleProduct->variations as $v){
            $sid = (int)($v->size_id ?? 0);
            $cid = (int)($v->color_id ?? 0);

            $sizeLabel  = $v->size_label  ?? optional($v->size)->name  ?? ($v->size  ?? 'Default');
            $colorLabel = $v->color_label ?? optional($v->color)->name ?? ($v->color ?? 'Default');

            /* ✅ Hide default options (id=1) */
            if($sid && $sid !== $DEFAULT_SIZE_ID)  $sizesMap[$sid]  = $sizeLabel;
            if($cid && $cid !== $DEFAULT_COLOR_ID) $colorsMap[$cid] = $colorLabel;

            $base  = (float)($v->price ?? 0);
            $after = (float)($v->after_discount_price ?? 0);
            $disc  = (float)($v->discount_price ?? 0);

            if($after > 0 && $after < $base) $final = $after;
            elseif($disc > 0 && $disc < $base) $final = $disc;
            else $final = $base;

            $stock = (int)($v->stocks ? $v->stocks->sum('quantity') : 0);

            $key = $sid.'|'.$cid;
            $varMap[$key] = [
                'id'       => (int)$v->id,
                'size_id'  => $sid,
                'color_id' => $cid,
                'size'     => $sizeLabel,
                'color'    => $colorLabel,
                'raw'      => $base,
                'price'    => $final,
                'stock'    => $stock,
            ];
        }
    }

    $showSize  = count($sizesMap)  > 0;
    $showColor = count($colorsMap) > 0;

    /* ✅ Default variation pick */
    $defaultVar = $singleProduct->variations->first();
    if($defaultVar){
        foreach($singleProduct->variations as $v){
            if(!empty($v->is_default) && (int)$v->is_default === 1){
                $defaultVar = $v; break;
            }
        }
    }

    $defaultSizeId  = (int)($defaultVar->size_id ?? 0);
    $defaultColorId = (int)($defaultVar->color_id ?? 0);

    /* ✅ If default is "id=1 default" then auto-pick first visible option */
    if($showSize && ($defaultSizeId === $DEFAULT_SIZE_ID || $defaultSizeId === 0)){
        $defaultSizeId = (int)array_key_first($sizesMap);
    }
    if($showColor && ($defaultColorId === $DEFAULT_COLOR_ID || $defaultColorId === 0)){
        $defaultColorId = (int)array_key_first($colorsMap);
    }

    /* ✅ In case only size or only color exists, set other side to its default id */
    if($showSize && !$showColor){
        $defaultColorId = $DEFAULT_COLOR_ID;
    }
    if(!$showSize && $showColor){
        $defaultSizeId = $DEFAULT_SIZE_ID;
    }

    $initialKey = $defaultSizeId.'|'.$defaultColorId;
    $initialVar = $varMap[$initialKey] ?? (count($varMap) ? reset($varMap) : null);

    $fallbackRaw    = (float)($data['old_price'] ?? ($singleProduct->sell_price ?? 0));
    $fallbackFinal = (float)($data['price'] ?? (((float)($singleProduct->after_discount ?? 0) > 0) ? (float)$singleProduct->after_discount : (float)($singleProduct->sell_price ?? 0)));
    if($fallbackRaw <= 0)   $fallbackRaw    = (float)($singleProduct->sell_price ?? 0);
    if($fallbackFinal <= 0) $fallbackFinal = (float)($singleProduct->sell_price ?? 0);

    $baseOld   = (float)($initialVar['raw']   ?? $fallbackRaw);
    $baseFinal = (float)($initialVar['price'] ?? $fallbackFinal);

    $stockQty = (int)($initialVar['stock'] ?? ($singleProduct->stock_quantity ?? 0));
    $inStock  = $stockQty > 0;

    $hasDiscount = ($baseFinal > 0 && $baseOld > 0 && $baseFinal < $baseOld);
    $discPercent = $hasDiscount ? round((($baseOld - $baseFinal) / $baseOld) * 100, 0) : 0;

    $detailsUrl = url("/product-show/{$singleProduct->id}");

    $fmt = function($amount) use ($curr){
        $amount = (float)$amount;
        if($curr == 'BDT')    return '৳ '.(int)round($amount);
        if($curr == 'Dollar') return '$ '.number_format($amount, 2);
        if($curr == 'Euro')   return '€ '.number_format($amount, 2);
        return (string)$amount;
    };
?>

<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;500;600;700;800;900&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css"/>

<style>
  /* ✅ Root Variable Integration */
  :root {
      --brand-gradient: <?php echo $info->gradient_code ?? 'linear-gradient(90deg, #0d6efd, #00276C)'; ?>;
      --brand-text: #ffffff;
  }

  #quick-view-modal{ z-index:20000 !important; }
  .modal-backdrop{ z-index:19990 !important; }
  #quick-view-modal .modal-header button[data-bs-dismiss="modal"]:not(:last-child),
  #quick-view-modal .modal-header .pmodal-close,
  #quick-view-modal .modal-header .close,
  #quick-view-modal .modal-header .btn-close-left{ display:none !important; }

  /* ✅ Force Hind Siliguri Font */
  .pmodal, .pmodal *{ font-family:'Hind Siliguri', sans-serif !important; }

  /* Icon Fixes */
  .pmodal i.fa, .pmodal i.fas, .pmodal i.far, .pmodal i.fal, .pmodal i.fab,
  .pmodal .fa, .pmodal .fas, .pmodal .far, .pmodal .fal, .pmodal .fab{
    font-family:"Font Awesome 5 Free" !important; font-style:normal !important;
    display:inline-block !important; visibility:visible !important; opacity:1 !important; line-height:1 !important;
  }
  .pmodal .fas, .pmodal i.fas{ font-weight:900 !important; }
  .pmodal .far, .pmodal i.far{ font-weight:400 !important; }
  .pmodal .fab, .pmodal i.fab{ font-family:"Font Awesome 5 Brands" !important; font-weight:400 !important; }

  .pmodal-card{ background:#fff; border-radius:16px; border:1px solid rgba(0,0,0,.06); box-shadow:0 14px 40px rgba(2,6,23,.08); overflow:hidden; }
  .pmodal-grid{ display:grid; grid-template-columns: 1.05fr .95fr; gap:14px; align-items:start; }
  @media(max-width:991px){ .pmodal-grid{ grid-template-columns:1fr; } }
  .pmodal-media{ padding:12px; background:linear-gradient(180deg, rgba(0,39,108,.05), rgba(255,255,255,0)); border-right:1px solid rgba(0,0,0,.06); }
  @media(max-width:991px){ .pmodal-media{ border-right:0; border-bottom:1px solid rgba(0,0,0,.06); } }
  .pmodal-media .main-img{ width:100%; border-radius:14px; overflow:hidden; background:#fff; border:1px solid rgba(0,0,0,.06); }
  .pmodal-media .main-img img{ width:100%; height:auto; display:block; object-fit:cover; }
  .pmodal-thumbs{ display:flex; gap:8px; margin-top:10px; flex-wrap:wrap; }
  .pmodal-thumb{ width:58px; height:58px; border-radius:12px; overflow:hidden; border:1px solid rgba(0,0,0,.08); cursor:pointer; background:#fff; flex:0 0 auto; }
  .pmodal-thumb img{ width:100%; height:100%; object-fit:cover; display:block; }
  .pmodal-thumb.active{ outline:3px solid rgba(0,39,108,.25); }
  @media(max-width:575px){ .pmodal-thumbs{ flex-wrap:nowrap; overflow-x:auto; padding-bottom:6px; } .pmodal-thumb{ width:54px; height:54px; } }

  .pmodal-info{ padding:14px; }
  @media(max-width:575px){ .pmodal-info{ padding:12px; } }
  .pname{ font-weight:900; font-size:20px; margin:0 0 8px; }
  @media(max-width:575px){ .pname{ font-size:18px; } }

  .pprice{ margin:6px 0 10px; }
  .pprice-line{ display:flex; align-items:baseline; gap:14px; flex-wrap:wrap; }
  .pold{ color:#dc2626; font-weight:900; font-size:18px; opacity:.7; text-decoration:line-through; }
  .pnew{ color:#00276C; font-weight:900; font-size:30px; letter-spacing:.2px; }
  @media(max-width:575px){ .pnew{ font-size:28px; } .pold{ font-size:17px; } }

  .pbadges{ display:flex; gap:10px; flex-wrap:wrap; margin:14px 0 10px; }
  .pbadge{ padding:10px 16px; border-radius:999px; font-weight:900; font-size:18px; border:1px solid rgba(0,0,0,.10); }
  .pbadge.green{ background:rgba(34,197,94,.12); color:#166534; border-color:rgba(34,197,94,.35); }
  .pbadge.blue{ background:rgba(59,130,246,.12); color:#1d4ed8; border-color:rgba(59,130,246,.30); }
  .pbadge.red{ background:rgba(239,68,68,.12); color:#991b1b; border-color:rgba(239,68,68,.30); }

  .details-ratting-wrapper{ margin:6px 0 10px; }
  .details-ratting-wrapper i{ color:#FFDF00; }
  .details-ratting-wrapper i.far.fa-star{ color:#9ca3af; }

  .product-code{ margin:8px 0 12px; }
  .product-code p{ display:inline-flex; align-items:center; gap:8px; background:#3c7d17; color:#fff; padding:10px 12px; border-radius:12px; margin:0; font-weight:900; line-height:1.2; max-width:100%; white-space:nowrap; overflow:hidden; text-overflow:ellipsis; }
  @media(max-width:575px){ .product-code p{ white-space:normal; } }

  #pmodalVariantBox{ margin-top:10px; }
  #pmodalVariantBox label{ font-weight:900; margin:10px 0 6px; display:block; }
  .pvopt{ cursor:pointer; user-select:none; padding:8px 14px; border-radius:999px; border:1px solid rgba(17,24,39,.14); background:#fff; font-weight:900; display:inline-flex; align-items:center; gap:6px; }
  .pvopt.active{ border-color:#00276C; background:rgba(0,39,108,.08); outline:2px solid rgba(0,39,108,.20); }
  .size_name{ margin-top:10px; display:block; font-weight:900; color:#166534; }

  .qty-cart{ display:flex; align-items:center; gap:12px; flex-wrap:wrap; }
  .quantity{ position:relative; border:1px solid #111827; height:42px; overflow:hidden; width:140px; border-radius:10px; flex:0 0 auto; background:#fff; }
  .quantity .minus, .quantity .plus{ position:absolute; top:0; width:42px; height:42px; line-height:42px; text-align:center; cursor:pointer; font-weight:900; user-select:none; }
  .quantity .minus{ left:0; border-right:1px solid #111827; font-size:32px; }
  .quantity .plus{ right:0; border-left:1px solid #111827; font-size:24px; }
  .quantity input{ width:100%; height:100%; border:0; text-align:center; font-weight:900; background:#fff !important; }
  @media(max-width:575px){ .quantity{ width:100%; } }

  .btn-row{ display:flex; gap:10px; margin-top:10px; }

  /* ✅ Updated Add To Cart Button Style */
  .add_cart_btn{
      flex:1;
      color: #fff !important; /* টেক্সট কালার সাদা */
      background: linear-gradient(90deg, rgba(34,197,94,1), rgba(16,185,129,1)) !important;
      border: 1px solid transparent !important;
      height: 52px;
      border-radius: 14px;
      font-weight: 900;
      font-size: 18px;
  }

  /* ========================================= */
  /* 🔥 ORDER NOW BUTTON ANIMATION (POPUP) 🔥 */
  /* ========================================= */
  
  /* 1. Gradient Movement Animation */
  @keyframes gradientShake {
      0% { background-position: 0% 50%; }
      50% { background-position: 100% 50%; }
      100% { background-position: 0% 50%; }
  }

  /* 2. Pulse / Heartbeat Glow Animation */
  @keyframes glowingPulse {
      0% { 
          box-shadow: 0 0 0 0 rgba(13, 110, 253, 0.7); 
          transform: scale(1); 
      }
      50% { 
          box-shadow: 0 0 0 12px rgba(13, 110, 253, 0); 
          transform: scale(1.03); 
      }
      100% { 
          box-shadow: 0 0 0 0 rgba(13, 110, 253, 0); 
          transform: scale(1); 
      }
  }

  /* ✅ Updated Order Now Button Style */
  .order_now_btn{
      flex:1;
      height: 52px;
      border-radius: 14px;
      font-weight: 900;
      font-size: 18px;
      /* Gradient Background */
      background: linear-gradient(45deg, #00276C, #2563eb, #00276C, #3b82f6) !important;
      background-size: 300% 300% !important;
      color: #fff !important;
      border: none !important;
      /* Applying the Animations */
      animation: gradientShake 3s ease infinite, glowingPulse 2s infinite !important;
      position: relative;
      z-index: 1;
  }

  .order_now_btn:hover{
      filter: brightness(1.1);
  }
  /* ========================================= */

  @media(max-width:575px){ .btn-row{ flex-direction:column; } .add_cart_btn, .order_now_btn{ width:100%; height:52px; font-size:18px; } }
  button:disabled, .btn:disabled{ opacity:.55 !important; cursor:not-allowed !important; }

  .courier-card{ margin-top:14px; border:1px solid rgba(17,24,39,.12); border-radius:14px; overflow:hidden; background:#fff; }
  .courier-head{ background:linear-gradient(90deg, rgba(0,39,108,.10), rgba(60,125,23,.08)); padding:10px 12px; font-weight:900; color:#111827; text-align:center; border-bottom:1px solid rgba(17,24,39,.10); }
  .courier-table{ width:100%; border-collapse:collapse; margin:0; font-weight:900; table-layout:fixed; }
  .courier-table td{ padding:10px 12px; border-bottom:1px solid rgba(17,24,39,.08); vertical-align:middle; white-space:nowrap; overflow:hidden; text-overflow:ellipsis; }
  .courier-table tr:last-child td{ border-bottom:0; }
  .courier-table td.c-title{ width:70%; text-align:left; }
  .courier-table td.c-amount{ width:30%; text-align:right; }

  .details-btn-wrap{ display:flex; justify-content:center; margin-top:12px; }
  .details-btn{ width:min(420px,100%); height:46px; border-radius:12px; font-weight:900; font-size:16px; border:1px solid rgba(0,39,108,.25); background:rgba(0,39,108,.07); color:#00276C; display:flex; align-items:center; justify-content:center; gap:8px; text-decoration:none; }
  .details-btn:hover{ background:rgba(0,39,108,.12); color:#00276C; text-decoration:none; }
</style>

<div class="pmodal"
     data-popup="1"
     data-currency="<?php echo e(e($curr)); ?>"
     data-def-size="<?php echo e((int)$defaultSizeId); ?>"
     data-def-color="<?php echo e((int)$defaultColorId); ?>"
     data-show-size="<?php echo e($showSize ? 1 : 0); ?>"
     data-show-color="<?php echo e($showColor ? 1 : 0); ?>"
     data-default-size-id="<?php echo e((int)$DEFAULT_SIZE_ID); ?>"
     data-default-color-id="<?php echo e((int)$DEFAULT_COLOR_ID); ?>">

  <script type="application/json" id="pmodalVarJson"><?php echo json_encode($varMap, 15, 512) ?></script>

  <div class="pmodal-card">
    <div class="pmodal-grid">

      <div class="pmodal-media">
        <div class="main-img">
          <img id="pmodalMainImg" src="<?php echo e(getImage('products', $singleProduct->image)); ?>" alt="<?php echo e($singleProduct->name); ?>"/>
        </div>

        <div class="pmodal-thumbs" id="pmodalThumbs">
          <div class="pmodal-thumb active" data-src="<?php echo e(getImage('products', $singleProduct->image)); ?>">
            <img src="<?php echo e(getImage('products', $singleProduct->image)); ?>" alt="thumb">
          </div>

          <?php if(isset($singleProduct->images) && $singleProduct->images->count() > 0): ?>
            <?php $__currentLoopData = $singleProduct->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $im): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <div class="pmodal-thumb" data-src="<?php echo e(getImage('products', $im->image)); ?>">
                <img src="<?php echo e(getImage('products', $im->image)); ?>" alt="thumb">
              </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          <?php endif; ?>
        </div>
      </div>

      <div class="pmodal-info">

        <h3 class="pname"><?php echo e($singleProduct->name); ?></h3>

        <div class="pprice" id="pmodalPriceBox">
          <div class="pprice-line">
            <?php if($hasDiscount): ?>
              <span class="pold" id="pmodal_old_price"><?php echo e($fmt($baseOld)); ?></span>
            <?php else: ?>
              <span class="pold" id="pmodal_old_price" style="display:none;"></span>
            <?php endif; ?>
            <span class="pnew" id="pmodal_final_price"><?php echo e($fmt($baseFinal)); ?></span>
          </div>
        </div>

        <div class="pbadges">
          <span class="pbadge <?php echo e($inStock ? 'green' : 'red'); ?>" id="pmodal_stock_badge">
            <?php echo e($inStock ? $stockQty : 0); ?> Items left
          </span>

          <?php if($hasDiscount): ?>
            <span class="pbadge blue" id="pmodal_disc_badge"><?php echo e($discPercent); ?>% Off</span>
          <?php else: ?>
            <span class="pbadge blue" id="pmodal_disc_badge" style="display:none;"></span>
          <?php endif; ?>
        </div>

        <div class="details-ratting-wrapper">
          <?php
            $totalReviews  = $singleProduct->reviews->count();
            $averageRating = $totalReviews > 0 ? round($singleProduct->reviews->avg('review'), 2) : 0;
          ?>
          <span style="font-weight:900;"><?php echo e($totalReviews); ?> Reviews</span>
          <?php for($i = 1; $i <= 5; $i++): ?>
            <?php if($i <= $averageRating): ?>
              <i class="fas fa-star"></i>
            <?php elseif($i - 0.5 <= $averageRating): ?>
              <i class="fas fa-star-half-alt"></i>
            <?php else: ?>
              <i class="far fa-star"></i>
            <?php endif; ?>
          <?php endfor; ?>
          <span style="font-weight:900;"><?php echo e(number_format($averageRating, 2)); ?>/5</span>
        </div>

        <div class="product-code">
          <p>
            <span><?php echo e($dt->product_code_text ?? 'প্রোডাক্ট কোড :'); ?></span>
            <?php echo e($singleProduct->sku); ?>

          </p>
        </div>

        <?php if(count($varMap) > 0 && ($showSize || $showColor)): ?>
          <div class="mt-2" id="pmodalVariantBox">

            <?php if($showSize): ?>
              <label class="mb-2">Size:</label>
              <div class="d-flex flex-wrap gap-2" id="pmodalSizeOptions">
                <?php $__currentLoopData = $sizesMap; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sid => $slabel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <span class="pvopt pmodal-size-opt <?php echo e(((int)$sid === (int)$defaultSizeId) ? 'active' : ''); ?>"
                        data-size-id="<?php echo e((int)$sid); ?>"><?php echo e($slabel); ?></span>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </div>
            <?php endif; ?>

            <?php if($showColor): ?>
              <label class="mb-2">Color:</label>
              <div class="d-flex flex-wrap gap-2" id="pmodalColorOptions">
                <?php $__currentLoopData = $colorsMap; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cid => $clabel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <span class="pvopt pmodal-color-opt <?php echo e(((int)$cid === (int)$defaultColorId) ? 'active' : ''); ?>"
                        data-color-id="<?php echo e((int)$cid); ?>"><?php echo e($clabel); ?></span>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </div>
            <?php endif; ?>

            <span class="size_name" id="pmodal_variant_label"></span>
          </div>
        <?php endif; ?>

        <form action="<?php echo e(route('front.carts.storeCart')); ?>" id="cart_submit_popup" method="POST">
          <?php echo csrf_field(); ?>
          <input type="hidden" name="product_id" value="<?php echo e($singleProduct->id); ?>">
          <input type="hidden" name="product_name" value="<?php echo e($singleProduct->name); ?>">
          <input type="hidden" name="category_id" value="<?php echo e($singleProduct->category->name ?? ''); ?>">

          <input type="hidden" name="variation_id" id="pmodal_variation_id" value="<?php echo e($initialVar['id'] ?? ''); ?>">
          <input type="hidden" name="variant_name" id="pmodal_variant_name" value="">
          <input type="hidden" id="pmodal_size_value"  name="size_value"  value="">
          <input type="hidden" id="pmodal_size_value1" name="size_value1" value="">
          <input type="hidden" id="pmodal_price_val"  name="price_val"  value="<?php echo e($baseFinal); ?>">
          <input type="hidden" id="pmodal_price_val1" name="price_val1" value="<?php echo e($baseFinal); ?>">
          <input type="hidden" name="action_type" id="popup_action_type" value="cart">

          <div class="mt-2">
            <div class="qty-cart">
              <div class="quantity" id="pmodalQty">
                <span class="minus">-</span>
                <input type="text" name="quantity" value="1" inputmode="numeric">
                <span class="plus">+</span>
              </div>
            </div>

            <div class="btn-row">
              <button type="button" class="btn add_cart_btn js-popup-cart" <?php echo e($inStock ? '' : 'disabled'); ?>>
                <?php echo e($dt->add_to_cart_text ?? 'কার্টে যোগ করুন'); ?>

              </button>

              <button type="button" class="btn order_now_btn js-popup-order" <?php echo e($inStock ? '' : 'disabled'); ?>>
                <?php echo e($dt->order_now_text ?? 'অর্ডার করুন'); ?>

              </button>
            </div>
          </div>

          <div class="courier-card">
            <div class="courier-head"><?php echo e($dt->courier_delivery_cost_text ?? 'কুরিয়ার ডেলিভারি খরচ'); ?></div>
            <table class="courier-table">
              <tbody>
              <?php $__currentLoopData = $charges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $charge): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                  <td class="c-title"><?php echo e($charge->title); ?></td>
                  <td class="c-amount">৳ <?php echo e(number_format($charge->amount, 0)); ?></td>
                </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </tbody>
            </table>
          </div>

          <div class="details-btn-wrap">
            <a class="details-btn" href="<?php echo e($detailsUrl); ?>">
              <i class="fas fa-info-circle"></i> Details
            </a>
          </div>

          <div class="mt-2">
            <ul class="product-metas"><?php echo $singleProduct->feature; ?></ul>
          </div>
        </form>

      </div>
    </div>
  </div>
</div>

<script>
(function(){
  const root = document.querySelector('.pmodal[data-popup="1"]');
  if(!root) return;

  const varJsonEl = document.getElementById('pmodalVarJson');
  const VAR_MAP   = varJsonEl ? JSON.parse(varJsonEl.textContent || '{}') : {};

  const showSize  = root.getAttribute('data-show-size') === '1';
  const showColor = root.getAttribute('data-show-color') === '1';
  const DEF_SIZE  = parseInt(root.getAttribute('data-default-size-id') || '1', 10);
  const DEF_COLOR = parseInt(root.getAttribute('data-default-color-id') || '1', 10);

  const oldEl   = document.getElementById('pmodal_old_price');
  const finalEl = document.getElementById('pmodal_final_price');
  const stockEl = document.getElementById('pmodal_stock_badge');
  const discEl  = document.getElementById('pmodal_disc_badge');

  const vIdEl   = document.getElementById('pmodal_variation_id');
  const vNameEl = document.getElementById('pmodal_variant_name');
  const sValEl  = document.getElementById('pmodal_size_value');
  const sVal1El = document.getElementById('pmodal_size_value1');
  const pValEl  = document.getElementById('pmodal_price_val');
  const pVal1El = document.getElementById('pmodal_price_val1');
  const labelEl = document.getElementById('pmodal_variant_label');

  const cartBtn  = root.querySelector('.js-popup-cart');
  const orderBtn = root.querySelector('.js-popup-order');
  const actionEl = document.getElementById('popup_action_type');
  const formEl   = document.getElementById('cart_submit_popup');

  const fmt = (amount) => {
    const curr = root.getAttribute('data-currency') || 'BDT';
    amount = parseFloat(amount || 0);
    if(curr === 'BDT') return '৳ ' + Math.round(amount);
    if(curr === 'Dollar') return '$ ' + amount.toFixed(2);
    if(curr === 'Euro') return '€ ' + amount.toFixed(2);
    return String(amount);
  };

  function getActiveSizeId(){
    if(!showSize) return DEF_SIZE;
    const a = root.querySelector('#pmodalSizeOptions .pmodal-size-opt.active');
    return a ? parseInt(a.getAttribute('data-size-id') || '0', 10) : 0;
  }
  function getActiveColorId(){
    if(!showColor) return DEF_COLOR;
    const a = root.querySelector('#pmodalColorOptions .pmodal-color-opt.active');
    return a ? parseInt(a.getAttribute('data-color-id') || '0', 10) : 0;
  }

  function resolveVariation(sid, cid){
    const key = String(sid) + '|' + String(cid);
    return VAR_MAP[key] || null;
  }

  function setBtns(disabled){
    if(cartBtn)  cartBtn.disabled  = !!disabled;
    if(orderBtn) orderBtn.disabled = !!disabled;
  }

  function applyVariation(v){
    if(!v) return;

    window.__PMODAL_ACTIVE_VAR__ = v;

    const stock = parseInt(v.stock || 0, 10);
    if(stockEl){
      stockEl.classList.remove('green','red');
      stockEl.classList.add(stock > 0 ? 'green' : 'red');
      stockEl.textContent = (stock > 0 ? stock : 0) + ' Items left';
    }

    if(finalEl) finalEl.textContent = fmt(v.price);

    const hasDisc = (parseFloat(v.raw || 0) > 0 && parseFloat(v.price || 0) > 0 && parseFloat(v.price) < parseFloat(v.raw));
    if(oldEl){
      if(hasDisc){
        oldEl.style.display = '';
        oldEl.textContent = fmt(v.raw);
      }else{
        oldEl.style.display = 'none';
        oldEl.textContent = '';
      }
    }

    if(discEl){
      if(hasDisc){
        const pct = Math.round(((parseFloat(v.raw) - parseFloat(v.price)) / parseFloat(v.raw)) * 100);
        discEl.style.display = '';
        discEl.textContent = pct + '% Off';
      }else{
        discEl.style.display = 'none';
        discEl.textContent = '';
      }
    }

    let labelParts = [];
    if(showSize && v.size && v.size !== 'Default') labelParts.push(v.size);
    if(showColor && v.color && v.color !== 'Default') labelParts.push(v.color);
    const label = labelParts.join(' - ');

    if(labelEl) labelEl.textContent = label;

    if(vIdEl) vIdEl.value = v.id || '';
    if(vNameEl) vNameEl.value = label || '';
    if(sValEl)  sValEl.value  = label || '';
    if(sVal1El) sVal1El.value = label || '';
    if(pValEl)  pValEl.value  = v.price || 0;
    if(pVal1El) pVal1El.value = v.price || 0;

    setBtns(stock <= 0);
  }

  function setInvalidState(){
    window.__PMODAL_ACTIVE_VAR__ = null;
    if(labelEl) labelEl.textContent = 'Not available';
    if(stockEl){
      stockEl.classList.remove('green');
      stockEl.classList.add('red');
      stockEl.textContent = '0 Items left';
    }
    setBtns(true);
  }

  function refreshFromActive(){
    const sid = getActiveSizeId() || DEF_SIZE;
    const cid = getActiveColorId() || DEF_COLOR;

    const v = resolveVariation(sid, cid);
    if(v) applyVariation(v);
    else setInvalidState();
  }

  /* ✅ Thumbs */
  const thumbs = root.querySelectorAll('#pmodalThumbs .pmodal-thumb');
  const mainImg = document.getElementById('pmodalMainImg');
  thumbs.forEach(t => {
    t.addEventListener('click', function(){
      thumbs.forEach(x => x.classList.remove('active'));
      t.classList.add('active');
      const src = t.getAttribute('data-src');
      if(mainImg && src) mainImg.src = src;
    });
  });

  /* ✅ Qty */
  const qty = root.querySelector('#pmodalQty');
  if(qty && !qty.dataset.bound){
    qty.dataset.bound = '1';
    const minus = qty.querySelector('.minus');
    const plus  = qty.querySelector('.plus');
    const inp   = qty.querySelector('input[name="quantity"]');

    if(plus){
      plus.addEventListener('click', function(e){
        e.preventDefault();
        let v = parseInt(inp.value || '1', 10);
        if(!v || v < 1) v = 1;
        inp.value = v + 1;
      });
    }
    if(minus){
      minus.addEventListener('click', function(e){
        e.preventDefault();
        let v = parseInt(inp.value || '1', 10);
        if(!v || v < 1) v = 1;
        inp.value = Math.max(1, v - 1);
      });
    }
  }

  /* ✅ Size/Color click */
  root.querySelectorAll('#pmodalSizeOptions .pmodal-size-opt').forEach(el => {
    el.addEventListener('click', function(){
      root.querySelectorAll('#pmodalSizeOptions .pmodal-size-opt').forEach(x => x.classList.remove('active'));
      el.classList.add('active');
      refreshFromActive();
    });
  });

  root.querySelectorAll('#pmodalColorOptions .pmodal-color-opt').forEach(el => {
    el.addEventListener('click', function(){
      root.querySelectorAll('#pmodalColorOptions .pmodal-color-opt').forEach(x => x.classList.remove('active'));
      el.classList.add('active');
      refreshFromActive();
    });
  });

  /* ✅ Init active (ensure first option active if none) */
  if(showSize){
    const hasActive = root.querySelector('#pmodalSizeOptions .pmodal-size-opt.active');
    if(!hasActive){
      const first = root.querySelector('#pmodalSizeOptions .pmodal-size-opt');
      if(first) first.classList.add('active');
    }
  }
  if(showColor){
    const hasActive = root.querySelector('#pmodalColorOptions .pmodal-color-opt.active');
    if(!hasActive){
      const first = root.querySelector('#pmodalColorOptions .pmodal-color-opt');
      if(first) first.classList.add('active');
    }
  }
  refreshFromActive();

  /* ✅ Cart / Order buttons -> submit */
  function submitAs(type){
    if(!formEl) return;
    if(actionEl) actionEl.value = type;

    if(!window.__PMODAL_ACTIVE_VAR__){
      if(window.toastr){ toastr.clear(); toastr.warning('❌ এই Size-Color কম্বিনেশনটি নেই'); }
      return;
    }
    const stock = parseInt(window.__PMODAL_ACTIVE_VAR__.stock || 0, 10);
    if(stock <= 0){
      if(window.toastr){ toastr.clear(); toastr.warning('❌ এই ভ্যারিয়েশনটি স্টকে নেই'); }
      return;
    }

    /* normal submit */
    formEl.submit();
  }

  if(cartBtn){
    cartBtn.addEventListener('click', function(e){
      e.preventDefault();
      submitAs('cart');
    });
  }
  if(orderBtn){
    orderBtn.addEventListener('click', function(e){
      e.preventDefault();
      submitAs('order');
    });
  }

  // ✅✅ ADDED: Facebook Pixel Tracking for Quick View Popup (ViewContent)
  try {
      if(typeof fbq === 'function'){
          let product_id   = "<?php echo e($singleProduct->id); ?>";
          let product_name = "<?php echo e($singleProduct->name); ?>";
          let category_id  = "<?php echo e($singleProduct->category->name ?? ''); ?>";
          let price        = "<?php echo e(($singleProduct->after_discount > 0) ? $singleProduct->after_discount : $singleProduct->sell_price); ?>";
          
          let eventID = "SV_" + product_id + "_" + Date.now();

          fbq('track', 'ViewContent', {
              content_ids: [product_id],
              content_name: product_name,
              content_type: 'product',
              value: price,
              currency: 'BDT',
              content_category: category_id,
              contents: [{
                  id: product_id,
                  quantity: 1,
                  item_price: price
              }]
          }, { eventID: eventID });
      }
  } catch(e) { console.log('Pixel Error:', e); }
  // ✅✅ END ADDED CODE

})();
</script><?php /**PATH F:\php8212\htdocs\ecommerce\resources\views/frontend/products/partials/product_popup.blade.php ENDPATH**/ ?>