

<?php $__env->startSection('content'); ?>

<style>
    .card-premium {
        border: none;
        box-shadow: 0 0.75rem 1.5rem rgba(18, 38, 63, 0.03);
        border-radius: 12px;
        background: #fff;
    }
    .table-premium thead th {
        background-color: #f8f9fa;
        color: #495057;
        font-weight: 600;
        text-transform: uppercase;
        font-size: 0.8rem;
        border-bottom: 2px solid #eff2f7;
        padding: 12px 15px;
    }
    .table-premium tbody td {
        padding: 15px;
        vertical-align: middle;
        color: #495057;
        border-bottom: 1px solid #eff2f7;
    }
    .product-img {
        width: 45px;
        height: 45px;
        object-fit: cover;
        border: 2px solid #fff;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }
    .action-btn {
        width: 35px;
        height: 35px;
        padding: 0;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        border-radius: 50%;
        transition: all 0.3s;
        cursor: pointer;
    }
    .action-btn:hover {
        transform: translateY(-2px);
    }
    .page-title {
        font-weight: 700;
        color: #343a40;
    }
</style>

<div class="row">
    <div class="col-12">
        <div class="page-title-box d-sm-flex align-items-center justify-content-between py-3">
            <h4 class="page-title mb-0">Free Shipping Product List</h4>
            <div class="page-title-right">
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item"><a href="javascript: void(0);">SIS</a></li>
                    <li class="breadcrumb-item"><a href="javascript: void(0);">CRM</a></li>
                    <li class="breadcrumb-item active">Discount List</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card card-premium">
            <div class="card-body">
                <div class="row mb-4 align-items-center">
                    <div class="col-md-6 col-lg-4 mb-3 mb-md-0">
                        <div class="position-relative">
                            <input type="search" class="form-control rounded-pill ps-4" id="searchInput" placeholder="Search products...">
                            <span class="mdi mdi-magnify position-absolute top-50 end-0 translate-middle-y me-3 text-muted"></span>
                        </div>
                    </div>
                    
                    <div class="col-md-6 col-lg-8">
                        <div class="d-flex flex-wrap gap-2 justify-content-md-end">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('discount.create')): ?>
                            <a href="<?php echo e(route('admin.create_free_shipping')); ?>" class="btn btn-primary rounded-pill shadow-sm">
                                <i class="mdi mdi-plus-circle-outline me-1"></i> Add Product
                            </a>
                            <?php endif; ?>
                            <button type="button" class="btn btn-light rounded-pill border">
                                <i class="mdi mdi-export me-1"></i> Export
                            </button>
                        </div>
                    </div>
                </div>

                <div class="table-responsive">
                    <table class="table table-nowrap table-hover table-premium mb-0" id="productTable">
                        <thead>
                            <tr>
                                <th>Product Name</th>
                                <th>Image</th>
                                <th class="text-end" style="width: 100px;">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr id="row_<?php echo e($item->id); ?>">
                                <td>
                                    <h5 class="font-size-14 mb-0 text-dark"><?php echo e($item->name); ?></h5>
                                </td>
                                <td>
                                    <div class="flex-shrink-0">
                                        <img src="<?php echo e(getImage('products',$item->image)); ?>" class="rounded-circle product-img" alt="<?php echo e($item->name); ?>">
                                    </div>
                                </td>
                                <td class="text-end">
                                    <button type="button" 
                                            class="btn btn-soft-danger text-danger bg-danger bg-opacity-10 action-btn delete-item-btn" 
                                            data-id="<?php echo e($item->id); ?>" 
                                            title="Delete">
                                        <i class="mdi mdi-trash-can-outline font-size-16"></i>
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="3" class="text-center py-4 text-muted">
                                    <i class="mdi mdi-alert-circle-outline display-4 d-block mb-2"></i>
                                    No products found.
                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                
                <?php if(method_exists($items, 'links')): ?>
                <div class="mt-4 d-flex justify-content-end">
                    <?php echo e($items->links()); ?>

                </div>
                <?php endif; ?>

            </div> </div> </div> </div> <?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script type="text/javascript">
$(document).ready(function() {
    
    // Search Functionality
    $("#searchInput").on("keyup", function() {
        var value = $(this).val().toLowerCase();
        $("#productTable tbody tr").filter(function() {
            $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
        });
    });

    // Delete Action
    $(document).on('click', '.delete-item-btn', function (e){
        e.preventDefault(); // Prevent default behavior
        
        let id = $(this).data('id');
        let url = "<?php echo e(route('admin.free-shipping.fshippingdestroy')); ?>";
        let row = $('#row_' + id);

        // SweetAlert Confirmation
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                
                $.ajax({
                    url: url,
                    type: 'GET',
                    dataType: "json",
                    data: {product_id: id},
                    success: function(res) {
                        if(res.status == true){
                            Swal.fire(
                                'Deleted!',
                                res.msg,
                                'success'
                            );
                            
                            // Remove row smoothly
                            row.fadeOut(500, function(){
                                $(this).remove();
                            });
                        } else {
                            Swal.fire(
                                'Error!',
                                'Something went wrong!',
                                'error'
                            );
                        }
                    },
                    error: function(err){
                         Swal.fire(
                            'Error!',
                            'Server Error occurred.',
                            'error'
                        );
                    }
                });
            }
        });
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('backend.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\php8212\htdocs\ecommerce\resources\views/backend/product_discounts/free_shipping.blade.php ENDPATH**/ ?>