<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>New Order Notification</title>
    <style>
        body { font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif; background-color: #f4f6f9; margin: 0; padding: 0; -webkit-font-smoothing: antialiased; }
        .wrapper { width: 100%; background-color: #f4f6f9; padding: 40px 0; }
        .container { max-width: 600px; margin: 0 auto; background-color: #ffffff; border-radius: 8px; overflow: hidden; box-shadow: 0 4px 10px rgba(0,0,0,0.05); }
        .header { background-color: #2c3e50; padding: 30px; text-align: center; }
        .header h1 { color: #ffffff; margin: 0; font-size: 24px; font-weight: 600; letter-spacing: 1px; }
        .content { padding: 30px; }
        .status-badge { background-color: #e3f2fd; color: #0d47a1; padding: 5px 10px; border-radius: 4px; font-size: 12px; font-weight: bold; text-transform: uppercase; letter-spacing: 0.5px; }
        .info-grid { display: table; width: 100%; margin-bottom: 25px; border-bottom: 1px solid #eeeeee; padding-bottom: 20px; }
        .info-col { display: table-cell; width: 50%; vertical-align: top; }
        .label { font-size: 11px; text-transform: uppercase; color: #95a5a6; letter-spacing: 0.5px; margin-bottom: 5px; font-weight: 600; }
        .value { font-size: 14px; color: #2c3e50; font-weight: 500; line-height: 1.4; }
        
        .product-table { width: 100%; border-collapse: collapse; margin-bottom: 25px; }
        .product-table th { text-align: left; font-size: 11px; text-transform: uppercase; color: #95a5a6; padding: 10px 0; border-bottom: 2px solid #eeeeee; }
        .product-table td { padding: 12px 0; border-bottom: 1px solid #eeeeee; font-size: 14px; color: #34495e; vertical-align: middle; }
        .product-img { width: 40px; height: 40px; border-radius: 4px; object-fit: cover; margin-right: 10px; vertical-align: middle; border: 1px solid #eee; }
        .total-section { background-color: #f8f9fa; padding: 20px; border-radius: 6px; }
        .total-row { display: flex; justify-content: space-between; margin-bottom: 8px; font-size: 13px; color: #7f8c8d; }
        .total-row.final { border-top: 1px solid #e0e0e0; margin-top: 10px; padding-top: 10px; font-size: 16px; font-weight: 700; color: #2c3e50; }
        .footer { background-color: #f8f9fa; padding: 20px; text-align: center; font-size: 12px; color: #95a5a6; border-top: 1px solid #eeeeee; }
        .btn { display: inline-block; background-color: #3498db; color: #ffffff; padding: 12px 25px; text-decoration: none; border-radius: 4px; font-weight: bold; font-size: 14px; margin-top: 20px; text-align: center; }
        .btn:hover { background-color: #2980b9; }
    </style>
</head>
<body>
    <div class="wrapper">
        <div class="container">
            <div class="header">
                <h1><?php echo e($settings->site_name ?? 'New Order'); ?></h1>
            </div>

            <div class="content">
                <div style="text-align: center; margin-bottom: 30px;">
                    <img src="https://cdn-icons-png.flaticon.com/512/1170/1170576.png" alt="Cart" width="50" style="margin-bottom: 15px; opacity: 0.8;">
                    <h2 style="margin: 0 0 5px 0; color: #2c3e50;">New Order Received!</h2>
                    
                    <p style="margin: 0; color: #7f8c8d; font-size: 14px;">
                        Invoice: <strong>#<?php echo e($order->invoice_no); ?></strong>
                        <span style="margin: 0 5px; color: #cbd5e0;">|</span>
                        Order ID: <strong>#<?php echo e($order->id); ?></strong>
                    </p>
                </div>

                <div class="info-grid">
                    <div class="info-col">
                        <div class="label">Customer Details</div>
                        <div class="value">
                            <?php echo e($order->first_name); ?> <?php echo e($order->last_name); ?><br>
                            <?php echo e($order->mobile); ?><br>
                            <?php echo e($order->shipping_address); ?>

                        </div>
                    </div>
                    <div class="info-col" style="text-align: right;">
                        <div class="label">Order Date</div>
                        <div class="value"><?php echo e(date('d M, Y', strtotime($order->created_at))); ?></div>
                        <br>
                        <div class="label">Payment Method</div>
                        <div class="value" style="text-transform: capitalize;"><?php echo e($order->payment_method ?? 'COD'); ?></div>
                    </div>
                </div>

                <div class="label">Order Summary</div>
                <table class="product-table">
                    <thead>
                        <tr>
                            <th width="60%">Item</th>
                            <th width="15%" style="text-align: center;">Qty</th>
                            <th width="25%" style="text-align: right;">Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $order->details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>
                                <div>
                                    <span style="font-weight: 500;"><?php echo e($detail->product->name ?? 'Product'); ?></span>
                                    <?php if($detail->variation_id): ?>
                                        <br><span style="font-size: 11px; color: #95a5a6;">
                                            Size: <?php echo e($detail->variation->size->title ?? '-'); ?> | Color: <?php echo e($detail->variation->color->name ?? '-'); ?>

                                        </span>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td style="text-align: center;"><?php echo e($detail->quantity); ?></td>
                            <td style="text-align: right;"><?php echo e($detail->unit_price * $detail->quantity); ?> Tk</td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>

                <div class="total-section">
                    <div class="total-row">
                        <span>Sub Total = </span>
                        <span><?php echo e($order->amount - ($order->shipping_charge ?? 0)); ?> Tk</span>
                    </div>
                    <div class="total-row">
                        <span>Delivery Charge</span>
                        <span>+ <?php echo e($order->shipping_charge); ?> Tk</span>
                    </div>
                    
                    <?php if($order->discount > 0): ?>
                    <div class="total-row" style="color: #e74c3c;">
                       <span>Discount</span>
                       <span>- <?php echo e($order->discount); ?> Tk</span>
                    </div>
                    <?php endif; ?>
                    
                    <div class="total-row final">
                        <span>Total Amount = </span>
                        <span><?php echo e($order->final_amount); ?> Tk</span>
                    </div>
                </div>

                <div style="text-align: center;">
                    <a href="<?php echo e(route('admin.orders.show', $order->id)); ?>" class="btn">View Order in Admin Panel</a>
                </div>
            </div>

            <div class="footer">
                &copy; <?php echo e(date('Y')); ?> <?php echo e($settings->site_name); ?>. All rights reserved.<br>
               BIZ CARE LTD.
            </div>
        </div>
    </div>
</body>
</html><?php /**PATH /home/deshitest/public_html/resources/views/emails/admin_new_order.blade.php ENDPATH**/ ?>